package com.finconsgroup.itserr.marketplace.discussion.dm.repository;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionCountByReactionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * Repository interface for managing {@code DiscussionReaction} entities.
 * This interface extends {@code JpaRepository} to provide standard CRUD operations
 * and query methods for the {@code DiscussionReaction} entity.
 *
 * The primary key type for {@code DiscussionReaction} is {@code UUID}.
 *
 * Key responsibilities:
 * - Enable database access for persisting and retrieving {@code DiscussionReaction} entities.
 * - Leverage Spring Data JPA to inherit built-in query methods for operations like save, find, delete, and more.
 *
 * Annotated with {@code @Repository} to indicate that it is a Spring-managed data access component.
 */
@Repository
public interface DiscussionReactionRepository extends JpaRepository<DiscussionReaction, UUID> {

    Optional<DiscussionReaction> findByDiscussionAndUserId(Discussion discussion, String userId);

    void deleteByDiscussionAndUserId(Discussion discussion, String userId);

    @Query("SELECT new com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionCountByReactionDto(dr.reaction, COUNT(dr)) FROM DiscussionReaction dr WHERE dr.discussion = :discussion GROUP BY dr.reaction")
    List<DiscussionCountByReactionDto> countByDiscussionGroupByReactionType(@Param("discussion") Discussion discussion);
}
