package com.finconsgroup.itserr.marketplace.discussion.dm.dto;

import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import lombok.*;
import java.time.Instant;
import java.util.UUID;

/**
 * Data Transfer Object for ThreadReaction entity.
 * This DTO is used to transfer thread reaction data between different layers of the application.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class ThreadReactionDTO {

    /**
     * The universally unique identifier (UUID) for the thread reaction.
     */
    private UUID id;

    /**
     * The identifier of the user who created the reaction.
     */
    private String userId;

    /**
     * The type of reaction (LIKE, CELEBRATE, LOVE, INSIGHTFUL, CURIOUS).
     */
    private ReactionType reaction;

    /**
     * The date and time when the reaction was created.
     */
    private Instant createdAt;
}
