/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadCountByReactionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.ThreadReactionRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class ThreadMapper {
    protected ThreadReactionRepository threadReactionRepository;

    @Autowired
    public void setThreadReactionRepository(ThreadReactionRepository threadReactionRepository) {
        this.threadReactionRepository = threadReactionRepository;
    }

    @Mappings(value={@Mapping(target="parentId", source="parent.id"), @Mapping(target="reactionCounts", ignore=true)})
    public abstract ThreadDTO toDTO(Thread var1);

    @AfterMapping
    protected void afterToDTO(Thread thread, @MappingTarget ThreadDTO dto) {
        if (thread == null || dto == null) {
            return;
        }
        dto.setReactionCounts(this.calculateThreadReactionCounts(thread));
    }

    @Mappings(value={@Mapping(target="discussion", ignore=true), @Mapping(target="parent", ignore=true), @Mapping(target="replies", ignore=true), @Mapping(target="reactions", ignore=true)})
    public abstract Thread toEntity(ThreadDTO var1);

    protected List<ThreadDTO> mapThreadRepliesToDTO(List<Thread> replies) {
        if (replies == null) {
            return null;
        }
        return replies.stream().map(arg_0 -> this.toDTO(arg_0)).collect(Collectors.toList());
    }

    protected Map<ReactionType, Long> calculateThreadReactionCounts(Thread thread) {
        List results = this.threadReactionRepository.countByThreadGroupByReactionType(thread);
        HashMap<ReactionType, Long> reactionCounts = new HashMap<ReactionType, Long>();
        if (results != null) {
            for (ThreadCountByReactionDto r : results) {
                reactionCounts.put(r.getReaction(), r.getCount());
            }
        }
        return reactionCounts;
    }
}

