package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.impl;

import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link EventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerEventProducer implements EventProducer {

    @Override
    public void publishCreatedEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", resource);
    }

    @Override
    public void publishUpdatedEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - UPDATED event for resource: {}", resource);
    }

    @Override
    public void publishDeletedEvent(@NotNull MessagingEventDto<?> resource) {
        log.info("Message dispatch skipped (local profile) - DELETED event for resource: {}", resource);
    }

    @Override
    public void publishThreadCreatedEvent(@NotNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", eventDto);
    }

}