package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;

/**
 * Output DTO representing a created audit.
 */
@Schema(name = "OutputAuditDto", description = "DTO representing a audit in responses")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputAuditLogDto {

    @Schema(description = "Unique identifier of the audit log", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The source of the event, usually this represents the microservice which generated the event",
            example = "catalog-bs")
    private String eventSource;

    @Schema(description = "The type of the event.", example = "catalog-item-event-created")
    private String eventType;

    @Schema(description = "The user from User Profile whose action triggered the event.")
    private OutputAuditLogUserDto user;

    @Schema(description = "The resource on which the event was triggered.")
    private OutputAuditLogResourceDto resource;

    @Schema(description = "The message indicating the reason for an action.",
            example = "Approved as everything looks correct")
    private String eventMessage;

    @Schema(description = "The additional data that was provided on the event by the source microservice")
    private Map<String, Object> eventAdditionalData;

    @Schema(description = "The time at which the event action was actually triggered by the user.",
            example = "2025-08-25T11:22:33.123456Z")
    private Instant eventActionTime;

    @Schema(description = "The time at which the event was generated by the source microservice.",
            example = "2025-08-25T11:23:32.123456Z")
    private Instant eventCreationTime;

    @Schema(description = "The creation time of the table record", example = "2025-08-25T15:29:06.254836Z")
    private Instant creationTime;
}
