package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import static com.finconsgroup.itserr.marketplace.audit.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.audit.dm.util.DomainConstants.SHORT_TEXT_LENGTH;

/**
 * Input DTO for audit log resource.
 */
@Schema(name = "InputAuditLogResourceDto", description = "Input DTO for audit log resource")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputAuditLogResourceDto {

    @Schema(description = "The identifier of the resource on which the event was triggered.",
            example = "f71ce693-e760-47d6-bc5c-90edac51c653")
    @NotBlank
    @Size(max = SHORT_TEXT_LENGTH)
    private String id;

    @Schema(description = "The name of the resource on which the event was triggered.", example = "Talmud")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String name;

    @Schema(description = "The title of the resource on which the event was triggered.", example = "Annual Conference")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String title;

    @Schema(description = "The category of the resource on which the event was triggered.", example = "project")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String category;

    @Schema(description = "The status of the resource on which the event was triggered.", example = "approved")
    @Size(max = SHORT_TEXT_LENGTH)
    private String status;

}
