/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.service.AuditLogService;
import com.finconsgroup.itserr.messaging.consumer.AbstractEventSubscriber;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="messagingEventSubscriber")
public class MessagingEventSubscriber
extends AbstractEventSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingEventSubscriber.class);
    private static final TypeReference<UntypedMessagingEventDto> TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final AuditLogService auditLogService;

    public MessagingEventSubscriber(AuditLogService auditLogService) {
        super(TYPE_REFERENCE);
        this.auditLogService = auditLogService;
    }

    protected <V> void handleEvent(V eventData, @NonNull CloudEvent cloudEvent) {
        if (eventData instanceof UntypedMessagingEventDto) {
            UntypedMessagingEventDto untypedMessagingEventDto = (UntypedMessagingEventDto)eventData;
            OutputAuditLogDto outputAuditLogDto = this.auditLogService.createFromMessagingEvent(untypedMessagingEventDto, cloudEvent);
            log.info("Created audit log with id: {}", (Object)outputAuditLogDto.getId());
        } else {
            log.warn("Unhandled event type: {}", (Object)cloudEvent.getType());
        }
    }
}

