package com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm;

import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto.OutputMetadataDmDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.UUID;

/**
 * Metadata DM microservice client.
 */
public interface MetadataLibsMetadataDmClient {

    /**
     * Finds a metadata by id.
     *
     * @param metadataId Metadata id.
     * @return Metadata.
     */
    @GetMapping(value = "/metadata/{metadataId}", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputMetadataDmDto findById(@PathVariable("metadataId") UUID metadataId);

}
