/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.NoSourceItemIdException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.NoZenodoAuthCodeException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemNotFoundException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemRetrieveException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.UnallowedSourceItemException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.ZenodoAuthFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class CustomExceptionHandler {
    @ExceptionHandler(value={NoSourceItemIdException.class})
    private ResponseEntity<ErrorResponseDto> handleNoSourceItemIdException(NoSourceItemIdException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.BAD_REQUEST, (String)ex.getMessage());
    }

    @ExceptionHandler(value={NoZenodoAuthCodeException.class})
    private ResponseEntity<ErrorResponseDto> handleNoZenodoAuthCodeException(NoZenodoAuthCodeException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.BAD_REQUEST, (String)ex.getMessage());
    }

    @ExceptionHandler(value={SourceItemNotFoundException.class})
    private ResponseEntity<ErrorResponseDto> handleSourceItemNotFoundException(SourceItemNotFoundException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.NOT_FOUND, (String)ex.getMessage());
    }

    @ExceptionHandler(value={SourceItemRetrieveException.class})
    private ResponseEntity<ErrorResponseDto> handleSourceItemRetrieveException(SourceItemRetrieveException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)ex.getMessage());
    }

    @ExceptionHandler(value={UnallowedSourceItemException.class})
    private ResponseEntity<ErrorResponseDto> handleUnallowedSourceItemException(UnallowedSourceItemException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.FORBIDDEN, (String)ex.getMessage());
    }

    @ExceptionHandler(value={ZenodoAuthFailureException.class})
    private ResponseEntity<ErrorResponseDto> handleZenodoAuthFailureException(ZenodoAuthFailureException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY, (String)ex.getMessage());
    }
}

