package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.util.Map;

/**
 * It represents the persistent structure of Discussion Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
        indexName = "#{@environment.getProperty('search-dm.discussion.search.index-name','itserr-alias-wp2-search-discussion')}",
        createIndex = false,
        alwaysWriteMapping = false,
        writeTypeHint = WriteTypeHint.FALSE
)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class Discussion implements ScoredDocument {

    @Id
    private String id;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String title;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String content;

    @Field(type = FieldType.Keyword)
    private String createdBy;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant createdAt;

    @Field(type = FieldType.Keyword)
    private String updatedBy;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updatedAt;

    @Field(type = FieldType.Keyword)
    private String resourceId;

    @Field(type = FieldType.Keyword)
    private String resourceType;

    @Field(type = FieldType.Keyword)
    private String visibility;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String url;

    @Field(type = FieldType.Object)
    private UserInfo userInfoDTO;

    @Field(type = FieldType.Object)
    private Map<String, Long> reactionCounts;

    @Field(type = FieldType.Long)
    private Long threadsCount;

    @Transient
    private Double score;

    /**
     * It represents the persistent structure of user profile association field.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class UserInfo {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String firstName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String lastName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String email;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String preferredUsername;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String imageUrl;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String shortBio;

        @Field(type = FieldType.Keyword)
        private String orcid;
    }
}
