package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the persistent structure of a related node (parent/child) of institutional page.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class RelatedInstitutionalPageDto {

    @Schema(description = "ID of the related institutional page", example = "11111111-bbbb-0000-0000-000000000000")
    private String institutionalPageId;

    @Schema(description = "Name of the related institutional page", example = "WP3 T-Res")
    private String institutionalPageName;

    @Schema(description = "ID of the related workspace folder", example = "22222222-bbbb-0000-0000-000000000000")
    private String workspaceFolderId;

    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;
}
