package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

/**
 * It represents the response for an Event search document.
 */
@Builder
@Schema(name = "OutputEventLocalSearchDto",
        title = "Event search document response DTO",
        description = "Represents the response for Event search document")
@Data
public class OutputEventLocalSearchDto {

    @Schema(description = "Unique identifier of the event", example = "550e8400-e29b-41d4-a716-446655440000")
    private String id;

    @Schema(description = "The title of the event", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The link for the event", example = "https://meeting.example.com/test123")
    private String eventLink;

    @Schema(description = "The type of event", example = "webinar")
    private String eventType;

    @Schema(description = "The content of the event", example = "Join us for the biggest tech conference of the year...")
    private String content;

    @Schema(description = "List of tags associated with the event", example = "[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<InstitutionalPageMinimalDto> institutionalPages;

    @Schema(description = "The image for the event")
    private ImageMinimalDto image;

    @Schema(description = "The timezone for the event", example = "Europe/Rome")
    private String timezone;

    @Schema(description = "The start date for the event based on schedules", example = "2025-06-18")
    private LocalDate startDate;

    @Schema(description = "The end date for the event based on schedules", example = "2025-06-20")
    private LocalDate endDate;

    @Schema(description = "The event schedules")
    private List<EventScheduleDto> schedules;

    @Schema(description = "The flag to indicate if the logged in user has registered/subscribed to the event",
            example = "false")
    private boolean subscribed;

    @Schema(description = "The event planner user")
    private UserProfileMinimalDto eventPlanner;

    @Schema(description = "The maintainer")
    private UserProfileMinimalDto maintainer;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}