package com.finconsgroup.itserr.marketplace.search.dm.repository.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.bean.TopHitsAggregationRequest;
import com.finconsgroup.itserr.marketplace.search.dm.opensearch.OpenSearchHelper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.data.core.OpenSearchOperations;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Repository Implementation for custom aggregation related queries using OpenSearch.
 * <br/>
 * Need to use Impl suffix as that is the standard for Spring Data Repository custom implementations
 * and there is no way to provide a prefix for now i.e. Default.
 */
@Component
@RequiredArgsConstructor
@Slf4j
public class CustomAggregationRepositoryOpenSearchImpl implements CustomAggregationRepository {

    private final OpenSearchClient openSearchClient;
    private final OpenSearchHelper openSearchHelper;
    private final OpenSearchOperations openSearchOperations;

    @Override
    public <T> Map<String, List<T>> findTopHitsForQueryByTerm(
            QueryRequest<T> queryRequest, TopHitsAggregationRequest<T> aggregationRequest) {

        String[] indexNames = openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = openSearchHelper.buildTopHitsByTermSearchRequest(queryRequest, aggregationRequest, indexNames);
        try {
            SearchResponse<T> searchResponse = openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return openSearchHelper.mapTopHitsByTermAggregateResponse(searchResponse, aggregationRequest);
        } catch (IOException e) {
            throw new WP2ExecutionException(e);
        }
    }
}
