package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.util.List;

import static com.finconsgroup.itserr.marketplace.search.dm.constant.Normalizers.KEYWORD;

/**
 * It represents the persistent structure of Profile Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
    indexName = "#{@environment.getProperty('search-dm.profile.search.index-name','itserr-alias-wp2-search-profile')}",
    createIndex = false,
    alwaysWriteMapping = false,
    writeTypeHint = WriteTypeHint.FALSE
)
@Setting(settingPath = "/settings/normalizer_keyword.json")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserProfile implements ScoredDocument {

    @Id
    private String id;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256, normalizer = KEYWORD)})
    private String firstName;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256, normalizer = KEYWORD)})
    private String lastName;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String email;

    @Field(type = FieldType.Keyword)
    private String userProfileFolderId;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String imageUrl;

    @Field(type = FieldType.Boolean)
    private Boolean userExists;

    @Field(type = FieldType.Object)
    private List<UserProfileProject> projects;

    @Field(type = FieldType.Object)
    private UserProfileCv cv;

    @Field(type = FieldType.Keyword)
    private String orcid;

    @Field(type = FieldType.Boolean)
    private Boolean openToCollaboration;

    @Field(type = FieldType.Boolean)
    private Boolean showPublicEmail;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String personalWebsite;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String linkedinProfile;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String socialProfile;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String shortBio;

    @Field(type = FieldType.Object)
    private Location workingLocation;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String organizationAffiliation;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private List<String> ssd;

    @Field(type = FieldType.Object)
    private List<Expertise> expertises;

    @Field(type = FieldType.Object)
    private References references;

    @Field(type = FieldType.Keyword)
    private String language;

    @Field(type = FieldType.Boolean)
    private boolean publicProfile;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private List<String> interests;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant creationTime;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updateTime;

    @Transient
    private Double score;

    /**
     * It represents the persistent structure of expertises field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Expertise {

        @Field(type = FieldType.Keyword)
        private String id;

        @Field(type = FieldType.Auto)
        private String labelId;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String displayName;

        @Field(type = FieldType.Integer)
        private Integer endorsementCount;

        @Field(type = FieldType.Object)
        private List<Endorsement> endorsements;

    }

    /**
     * It represents the persistent structure of endorsement field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Endorsement {

        @Field(type = FieldType.Keyword)
        private String endorserId;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String firstName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String lastName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String preferredUsername;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String email;

        @Field(type = FieldType.Auto)
        private String imageUrl;

        @Field(type = FieldType.Auto)
        private String shortBio;
    }

}
