/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.repository.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import com.finconsgroup.itserr.marketplace.search.dm.opensearch.OpenSearchHelper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.data.core.OpenSearchOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CustomQueryRepositoryOpenSearchImpl
implements CustomQueryRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomQueryRepositoryOpenSearchImpl.class);
    private final OpenSearchClient openSearchClient;
    private final OpenSearchHelper openSearchHelper;
    private final OpenSearchOperations openSearchOperations;

    public <T> List<T> findTopHitsForQuery(QueryRequest<T> queryRequest, int topHitsLimit) {
        String[] indexNames = this.openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = this.openSearchHelper.buildTopHitsSearchRequest(queryRequest, topHitsLimit, indexNames);
        try {
            SearchResponse searchResponse = this.openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return this.openSearchHelper.mapTopHitsSearchResponse(searchResponse, queryRequest);
        }
        catch (IOException e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    public <T> Page<T> findPageForQuery(QueryRequest<T> queryRequest, Pageable pageable) {
        String[] indexNames = this.openSearchOperations.getIndexCoordinatesFor(queryRequest.getDocumentClass()).getIndexNames();
        SearchRequest searchRequest = this.openSearchHelper.buildFindPageSearchRequest(queryRequest, pageable, indexNames);
        try {
            SearchResponse searchResponse = this.openSearchClient.search(searchRequest, queryRequest.getDocumentClass());
            return this.openSearchHelper.mapPageSearchResponse(searchResponse, queryRequest, pageable);
        }
        catch (IOException e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @Generated
    public CustomQueryRepositoryOpenSearchImpl(OpenSearchClient openSearchClient, OpenSearchHelper openSearchHelper, OpenSearchOperations openSearchOperations) {
        this.openSearchClient = openSearchClient;
        this.openSearchHelper = openSearchHelper;
        this.openSearchOperations = openSearchOperations;
    }
}

