package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

import java.util.List;

/**
 * It represents the response data transfer object for operations related to Global Search
 *
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Getter
@Builder
@Schema(
    title = "Global Search DTO",
    description = "Represents the response for Global Search operation"
)
@EqualsAndHashCode
@ToString
public class OutputGlobalSearchDto {
    @Schema(
        description = "Category to which the document belongs",
        example = "Catalog")
    private final String category;

    @Schema(
        description = "Sub Category for the document e.g. for Resources it would be Item Type",
        example = "dataset")
    private String type;

    @Schema(
        description = "The list of documents for the category")
    private final List<OutputGlobalSearchDataDto> data;
}
