/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.controller;

import com.finconsgroup.itserr.marketplace.notification.dm.api.UserNotificationApi;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.UserDto;
import com.finconsgroup.itserr.marketplace.notification.dm.service.LocalizedUserNotificationService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.NotificationTemplateService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.UserNotificationService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserNotificationController
implements UserNotificationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserNotificationController.class);
    private final UserNotificationService userNotificationService;
    private final LocalizedUserNotificationService localizedUserNotificationService;
    private final NotificationTemplateService notificationTemplateService;

    public Page<OutputLocalizedUserNotificationDto> findAll(Boolean read, Boolean archived, int pageNumber, int pageSize, String acceptLanguage) {
        UserDto user = UserDto.fromSecurityOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.localizedUserNotificationService.findAll(user, read, archived, (Pageable)pageable, acceptLanguage);
    }

    public void patchAll(InputPatchUserNotificationsDto request) {
        UserDto user = UserDto.fromSecurityOrThrow();
        this.userNotificationService.patchAll(user, request);
    }

    public OutputLocalizedUserNotificationDto findById(UUID notificationId, String acceptLanguage) {
        UserDto user = UserDto.fromSecurityOrThrow();
        return this.localizedUserNotificationService.findByUser(user, notificationId, acceptLanguage);
    }

    public List<OutputUserNotificationDto> createNotification(InputCreateUserNotificationDto inputCreateUserNotificationDto) {
        return this.userNotificationService.create(inputCreateUserNotificationDto);
    }

    public OutputPatchUserNotificationDto patchUserNotificationById(UUID notificationId, InputPatchUserNotificationDto inputPatchUserNotificationDto) {
        UserDto user = UserDto.fromSecurityOrThrow();
        return this.userNotificationService.patchById(user, notificationId, inputPatchUserNotificationDto);
    }

    public void deleteUserNotificationById(UUID notificationId) {
        UserDto user = UserDto.fromSecurityOrThrow();
        this.userNotificationService.deleteById(user, notificationId);
    }

    public List<OutputNotificationTemplateDto> getTemplatesByType(String notificationType) {
        return this.notificationTemplateService.findByType(notificationType);
    }

    @Generated
    public UserNotificationController(UserNotificationService userNotificationService, LocalizedUserNotificationService localizedUserNotificationService, NotificationTemplateService notificationTemplateService) {
        this.userNotificationService = userNotificationService;
        this.localizedUserNotificationService = localizedUserNotificationService;
        this.notificationTemplateService = notificationTemplateService;
    }
}

