/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.bs;

import com.finconsgroup.itserr.marketplace.metrics.dm.bs.MVUpdater;
import com.finconsgroup.itserr.marketplace.metrics.dm.bs.QueuedMVUpdater;
import com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.MVUpdateConfigurationProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class QueuedMVUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueuedMVUpdater.class);
    private static final long MILLIS_IN_MINUTE = 60000L;
    private final MVUpdateConfigurationProperties config;
    private final ApplicationEventPublisher publisher;
    private final MVUpdater mvUpdater;
    private long nextUpdateMinTimestampMs;

    public void update() {
        log.debug("Queued materialized view update");
        this.publisher.publishEvent((Object)new UpdateEvent());
    }

    @Async
    public void updateAfter(long delayMs) {
        if (delayMs > 0L) {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.update();
    }

    @EventListener
    @Async(value="mvUpdateExecutor")
    public void onUpdateEvent(UpdateEvent event) throws InterruptedException {
        boolean updated;
        long now = System.currentTimeMillis();
        long cooldownMs = this.nextUpdateMinTimestampMs - now;
        if (cooldownMs > 0L) {
            log.debug("Materialized view update cooldown for {} ms", (Object)cooldownMs);
            Thread.sleep(cooldownMs);
        }
        if (updated = this.mvUpdater.updateIfElderThan(event.timestamp)) {
            this.nextUpdateMinTimestampMs = System.currentTimeMillis() + (long)this.config.getCooldown() * 60000L;
        }
    }

    @Generated
    public QueuedMVUpdater(MVUpdateConfigurationProperties config, ApplicationEventPublisher publisher, MVUpdater mvUpdater) {
        this.config = config;
        this.publisher = publisher;
        this.mvUpdater = mvUpdater;
    }

    @Generated
    public long getNextUpdateMinTimestampMs() {
        return this.nextUpdateMinTimestampMs;
    }
}

