/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourceMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesDailyMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventDailyCount;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection.MetricSummaryProjection;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MapperConfiguration;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricTypeMapper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper(config=MapperConfiguration.class, uses={MetricTypeMapper.class})
public interface MetricMapper {
    default public OutputResourcesDailyMetricsDto toOutputResourcesDailyMetricsDto(Collection<MetricEventDailyCount> entities) {
        if (entities == null) {
            return new OutputResourcesDailyMetricsDto();
        }
        LinkedHashMap grouped = entities.stream().filter(e -> e.getResourceId() != null && e.getMetric() != null && e.getEventDay() != null).collect(Collectors.groupingBy(MetricEventDailyCount::getEventDay, LinkedHashMap::new, Collectors.groupingBy(MetricEventDailyCount::getResourceId, LinkedHashMap::new, Collectors.groupingBy(MetricEventDailyCount::getMetric, LinkedHashMap::new, Collectors.summingLong(e -> e.getEventsCount() == null ? 0L : e.getEventsCount())))));
        return this.toOutputResourcesDailyMetricsDto(grouped);
    }

    default public OutputResourcesDailyMetricsDto toOutputResourcesDailyMetricsDto(LinkedHashMap<LocalDate, LinkedHashMap<String, LinkedHashMap<MetricType, Long>>> dailyCounts) {
        MetricTypeMapper metricTypeMapper = (MetricTypeMapper)Mappers.getMapper(MetricTypeMapper.class);
        OutputResourcesDailyMetricsDto result = new OutputResourcesDailyMetricsDto();
        if (dailyCounts == null) {
            return result;
        }
        for (Map.Entry<LocalDate, LinkedHashMap<String, LinkedHashMap<MetricType, Long>>> dayEntry : dailyCounts.entrySet()) {
            LocalDate day = dayEntry.getKey();
            LinkedHashMap<String, LinkedHashMap<MetricType, Long>> dayResources = dayEntry.getValue();
            if (dayResources == null) continue;
            OutputResourcesMetricsDto resourcesMetrics = new OutputResourcesMetricsDto();
            result.put((Object)day, (Object)resourcesMetrics);
            for (Map.Entry<String, LinkedHashMap<MetricType, Long>> resEntry : dayResources.entrySet()) {
                String resourceId = resEntry.getKey();
                LinkedHashMap<MetricType, Long> resourceMetrics = resEntry.getValue();
                if (resourceId == null || resourceMetrics == null) continue;
                OutputResourceMetricsDto outResourceMetrics = new OutputResourceMetricsDto();
                LinkedHashMap<MetricDtoType, Double> metrics = new LinkedHashMap<MetricDtoType, Double>();
                outResourceMetrics.setMetrics(metrics);
                resourcesMetrics.put((Object)resourceId, (Object)outResourceMetrics);
                for (Map.Entry<MetricType, Long> metricEntry : resourceMetrics.entrySet()) {
                    MetricDtoType metricDto;
                    MetricType metric = metricEntry.getKey();
                    Long count = metricEntry.getValue();
                    if (metric == null || count == null) continue;
                    try {
                        metricDto = metricTypeMapper.metricTypeToMetricDtoType(metric);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    Double value = count.doubleValue();
                    metrics.put(metricDto, value);
                }
            }
        }
        return result;
    }

    default public OutputResourcesSummaryMetricsDto toOutputResourcesSummaryMetricsDto(Collection<MetricSummaryProjection> metrics) {
        OutputResourcesSummaryMetricsDto result = new OutputResourcesSummaryMetricsDto();
        if (metrics != null) {
            MetricTypeMapper metricTypeMapper = (MetricTypeMapper)Mappers.getMapper(MetricTypeMapper.class);
            metrics.forEach(m -> result.put((Object)metricTypeMapper.metricTypeToMetricDtoType(m.metricType()), (Object)(m.count() != null ? m.count().doubleValue() : 0.0)));
        }
        return result;
    }
}

