/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventNotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class CustomExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomExceptionHandler.class);

    @ExceptionHandler(value={MetricEventNotFoundException.class})
    public ResponseEntity<ErrorResponseDto> handleMetricEventNotFoundException(MetricEventNotFoundException ex, WebRequest request) {
        ExceptionUtils.logError((Exception)ex, (WebRequest)request);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.NOT_FOUND, (String)ex.getMessage());
    }

    @ExceptionHandler(value={MetricEventConflictException.class})
    public ResponseEntity<ErrorResponseDto> handleMetricEventConflictException(MetricEventConflictException ex) {
        log.debug("Metric event refused because of conflict");
        log.trace("Exception stacktrace: ", (Throwable)ex);
        return ExceptionUtils.createResponseEntityError((HttpStatus)HttpStatus.CONFLICT, (String)"Another metric event with the same resource and author already exists");
    }
}

