package com.finconsgroup.itserr.marketplace.metadata.dm.mapper;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;

import java.util.UUID;

/**
 * Metadata related mapper.
 */
@Mapper(config = MapperConfiguration.class, uses = MetadataFieldMapper.class)
public interface MetadataMapper {

    /**
     * Maps a {@link InputCreateMetadataDto} into a {@link MetadataEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "fields.id", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    @Mapping(target = "updatedBy", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "moderationMessage", ignore = true)
    @Mapping(target = "creatorId", source = "userId")
    MetadataEntity metadataSaveRequestDtoToMetadataEntity(InputCreateMetadataDto src, UUID userId);

    /**
     * Updates existing MetadataEntity with basic fields from InputUpdateMetadataDto.
     */
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    @Mapping(target = "updatedBy", ignore = true)
    @Mapping(target = "status", ignore = true)
    @Mapping(target = "moderationMessage", ignore = true)
    @Mapping(target = "creatorId", ignore = true)
    void updateEntity(InputUpdateMetadataDto dto, @MappingTarget MetadataEntity entity);

    /**
     * Maps a {@link MetadataEntity} into a {@link OutputMetadataDto}.
     *
     * @param src Source entity.
     * @return Mapped DTO.
     */
    OutputMetadataDto metadataEntityToMetadataDto(MetadataEntity src);

    /**
     * Maps a {@link MetadataEntity} into a {@link OutputMetadataPreviewDto}.
     *
     * @param src Source entity.
     * @return Mapped DTO.
     */
    OutputMetadataPreviewDto metadataEntityToMetadataPreviewDto(MetadataEntity src);

    /**
     * After mapping into a {@link MetadataEntity}, ensures that each of its fields has reference to the owning metadata.
     *
     * @param metadata Mapped {@link MetadataEntity}.
     */
    @AfterMapping
    default void setFieldsMetadataReference(@MappingTarget MetadataEntity metadata) {
        if (metadata != null && metadata.getFields() != null) {
            metadata.getFields().forEach(field -> field.setMetadata(metadata));
        }
    }

}
