package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to check if the specified metadata has one of the allowed statuses.
 *
 * <p>The status check is performed by fetching the metadata from the repository
 * and validating that its current status matches one of the allowed statuses.</p>
 *
 * <p>The annotation requires specifying which method parameter contains the metadata ID
 * and which statuses are allowed for the operation.</p>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequireMetadataStatus {

    /**
     * The name of the method parameter that contains the metadata ID.
     *
     * @return the parameter name (e.g., "metadataId")
     */
    String metadataIdParam() default "metadataId";

    /**
     * The allowed metadata statuses for executing the method.
     * Metadata must have one of these statuses (OR logic).
     *
     * @return array of allowed statuses (e.g., {MetadataStatus.DRAFT, MetadataStatus.PENDING})
     */
    MetadataStatus[] allowed();
}