package com.finconsgroup.itserr.marketplace.metadata.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;

import java.util.UUID;

/**
 * A business exception indicating that the operation cannot be completed because
 * the metadata does not exist.
 */
public class MetadataNotFoundException extends WP2ResourceNotFoundException {

    public static final String METADATA_NOT_FOUND_EXCEPTION_MESSAGE = "metadata with id: '%s' not found";

    /**
     * Constructor.
     * Create a specific based on input params
     *
     * @param id Metadata UUID.
     */
    public MetadataNotFoundException(UUID id) {
        super(METADATA_NOT_FOUND_EXCEPTION_MESSAGE.formatted(id.toString()));
    }

}
