package com.finconsgroup.itserr.marketplace.metadata.dm.mapper;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataFieldEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Metadata field related mapper.
 */
@Mapper(config = MapperConfiguration.class)
public interface MetadataFieldMapper {

    /**
     * Maps a {@link InputCreateMetadataFieldDto} into a {@link MetadataFieldEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "metadata", ignore = true)
    MetadataFieldEntity metadataFieldSaveRequestDtoToMetadataFieldEntity(InputCreateMetadataFieldDto src);

    /**
     * Maps a {@link MetadataFieldEntity} into a {@link OutputMetadataFieldDto}.
     *
     * @param src Source entity.
     * @return Mapped dto.
     */
    OutputMetadataFieldDto metadataFieldEntityToMetadataFieldDto(MetadataFieldEntity src);

    @Mapping(target = "field", source = "src")
    @Mapping(target = "metadata", source = "metadata")
    OutputMetadataFieldExtDto metadataFieldEntityToMetadataFieldExtDto(MetadataFieldEntity src);
}
