package com.finconsgroup.itserr.marketplace.metadata.dm.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Version;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

/**
 * Base class for any entity having an {@link UUID} as its id.
 */
@MappedSuperclass
@SuperBuilder
@Data
@NoArgsConstructor
public class AbstractUUIDEntity {

    /**
     * Entity id.
     */
    @Id
    @Column(name = "id", nullable = false, updatable = false)
    private UUID id;

    /**
     * Sets the id (if missing) on INSERT using {@link UUID#randomUUID()}.
     */
    @PrePersist
    public void prePersist() {
        if (id == null) {
            id = UUID.randomUUID();
        }
    }

}
