package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO of an institutionalPage.
 */
@Schema(name = "OutputInstitutionalPageDto", description = "Output DTO of an institutionalPage")
@Data
@Builder
@AllArgsConstructor
public class OutputInstitutionalPageDto {

    @Schema(description = "ID of the institutional page", example = "11111111-bbbb-0000-0000-000000000000")
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "Criterion")
    private String name;

    @Schema(
            description = "ID of the workspace folder related to the institutional page",
            example = "22222222-bbbb-0000-0000-000000000000"
    )
    private UUID workspaceFolderId;

    @Schema(description = "The parent node of the institutional page")
    private OutputRelatedInstitutionalPageDto parentInstitutionalPage;

    @Schema(description = "The child nodes of the institutional page")
    private List<OutputRelatedInstitutionalPageDto> childInstitutionalPages;

    @Schema(description = "ID of the root institutional page")
    private UUID rootInstitutionalPageId;

    @Schema(description = "Name of the root institutional page")
    private String rootInstitutionalPageName;

    @Schema(
            description = "IDs of the WP leads of the institutional page",
            example = "[\"33333333-aaaa-1111-0000-000000000000\",\"33333333-aaaa-2222-0000-000000000000\"]"
    )
    private List<UUID> wpLeads;

    @Schema(
            description = "IDs of members of the institutional page",
            example = "[\"33333333-aaaa-3333-0000-000000000000\",\"33333333-aaaa-4444-0000-000000000000\"]"
    )
    private List<UUID> members;

    @Schema(description = "Indicates whether the institutional page is published", example = "true")
    private Boolean published;

    @Schema(description = "Indicates whether the institutional page is waiting to be deleted", example = "true")
    private Boolean toDelete;

    @Schema(description = "Indicates whether the institutional page has an updated version", example = "true")
    private Boolean hasUpdatedVersion;

    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;

    @Schema(
            description = "The moderation status of the institutional page",
            allowableValues = {"Draft", "Pending", "Approved", "Rejected"},
            example = "Pending"
    )
    private String moderationStatus;

    @Schema(
            description = "The moderation status of the parallel version",
            allowableValues = {"Draft", "Pending", "Approved", "Rejected"},
            example = "Pending"
    )
    private String parallelVersionStatus;

    @Schema(
            description = "The time of publication of the institutional page",
            example = "2025-05-27T14:19:46.606883Z"
    )
    private Instant publicationTime;

    @Schema(
            description = "Message related to rejection of publish process",
            example = "The copyright is not compatible with our standard"
    )
    private String rejectionMessage;

    @Schema(
            description = "The abstract of the institutional page",
            example = "WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience."
    )
    private String abstractContent;

    @Schema(description = "Copyright info for the institutional page")
    private OutputCopyrightDto copyright;

    @Schema(description = "ID of the maintainer of the institutional page", example = "33333333-aaaa-1111-0000-000000000000")
    private UUID maintainer;

    @Schema(description = "The paragraphs related to the institutional page")
    private List<OutputParagraphDto> paragraphs;

    @Schema(description = "List of tags", example = "[\"aramaic\",\"english\",\"italian\"]")
    private List<String> tags;

    @Schema(description = "List of languages", example = "[\"English\",\"Italian\",\"German\"]")
    private List<String> languages;

    @Schema(description = "The image URL", example = "https://picsum.photos/200")
    private String imageUrl;

    @Schema(description = "The user manual URL", example = "https://www.usermanual.com")
    private String userManualUrl;

    @Schema(description = "The FAQs page URL", example = "https://www.faqs.com")
    private String faqsUrl;

    @Schema(description = "The application version", example = "v1.3.0")
    private String applicationVersion;

    @Schema(description = "The application type", example = "web application")
    private String applicationType;

    @Schema(description = "The license name", example = "MIT License")
    private String license;

    @Schema(description = "The supported operating systems", example = "Windows 10+, macOS 12+, Ubuntu 20.04+")
    private String supportedOs;

    @Schema(description = "The repository links for the institutional page")
    private OutputRepositoriesDto repositories;

    @Schema(
            description = "Additional arbitrary fields in key-value format",
            example = "{\"developer\": \"John Doe\", \"releaseNotes\": \"Initial beta release\"}"
    )
    private LinkedHashMap<String, String> additionalFields;

    @Schema(
            description = "External links in key-value format",
            example = "{\"Documentation\": \"https://docs.example.com\", \"GitHub\": \"https://github.com/project\"}"
    )
    private LinkedHashMap<String, String> externalLinks;

    @Schema(description = "Buttons related to the institutional page")
    private List<OutputButtonDto> buttons;

    @Schema(description = "ID of the user who is currently updating the entity", example = "11111111-bbbb-0000-0000-000000000000")
    private UUID updateLockedBy;

    @Schema(description = "ID of the last user who modified the institutional page", example = "33333333-aaaa-1111-0000-000000000000")
    private UUID lastModifiedBy;

    @Schema(description = "Created At", example = "2025-05-26T14:19:46.606883Z")
    private Instant creationTime;

    @Schema(description = "Last Updated At", example = "2025-05-27T14:19:46.606883Z")
    private Instant updateTime;

}
