/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberRequestHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InstitutionalPageNotFoundException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchForMemberInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.InstitutionalPageRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class InstitutionalPageHelper {
    private final InstitutionalPageRepository institutionalPageRepository;
    private final MemberRequestHelper memberRequestHelper;

    public boolean isRoot(InstitutionalPageEntity institutionalPageEntity) {
        return institutionalPageEntity.getParentInstitutionalPageId() == null;
    }

    public InstitutionalPageEntity save(UUID userId, InstitutionalPageEntity institutionalPageEntity) {
        institutionalPageEntity.setLastModifiedBy(userId);
        return (InstitutionalPageEntity)this.institutionalPageRepository.saveAndFlush((Object)institutionalPageEntity);
    }

    public void saveAll(UUID userId, List<InstitutionalPageEntity> institutionalPageEntities) {
        institutionalPageEntities.forEach(institutionalPageEntity -> institutionalPageEntity.setLastModifiedBy(userId));
        this.institutionalPageRepository.saveAllAndFlush(institutionalPageEntities);
    }

    public void delete(InstitutionalPageEntity institutionalPageEntity) {
        this.memberRequestHelper.deleteMemberRequestsForInstitutionalPage(institutionalPageEntity.getId());
        this.institutionalPageRepository.delete((Object)institutionalPageEntity);
    }

    public InstitutionalPageEntity retrieveInstitutionalPageOrThrow(UUID institutionalPageId, Supplier<? extends RuntimeException> exceptionSupplier) {
        return (InstitutionalPageEntity)this.institutionalPageRepository.findById((Object)institutionalPageId).orElseThrow(exceptionSupplier);
    }

    public InstitutionalPageEntity retrieveInstitutionalPage(UUID institutionalPageId) {
        return this.retrieveInstitutionalPageOrThrow(institutionalPageId, () -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public InstitutionalPageEntity retrieveLatestById(UUID institutionalPageId) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        List institutionalPages = this.retrieveAllWithFilter((Pageable)PageRequest.of((int)0, (int)2), searchFilters, null, Boolean.valueOf(false)).getContent();
        if (institutionalPages.isEmpty()) {
            throw new InstitutionalPageNotFoundException(institutionalPageId);
        }
        if (institutionalPages.size() == 1) {
            return (InstitutionalPageEntity)institutionalPages.getFirst();
        }
        return institutionalPages.stream().filter(institutionalPage -> institutionalPage.getOriginalInstitutionalPageId() != null).findFirst().orElseThrow(() -> InstitutionalPageHelper.foundNotRelatedIPsError((UUID)institutionalPageId, (List)institutionalPages));
    }

    public InstitutionalPageEntity retrieveLatestForMemberById(UUID userId, UUID institutionalPageId) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        List institutionalPages = this.retrieveAllForMemberWithFilter(userId, (Pageable)PageRequest.of((int)0, (int)2), searchFilters, null, Boolean.valueOf(false)).getContent();
        if (institutionalPages.isEmpty()) {
            throw new InstitutionalPageNotFoundException(institutionalPageId);
        }
        if (institutionalPages.size() == 1) {
            return (InstitutionalPageEntity)institutionalPages.getFirst();
        }
        return institutionalPages.stream().filter(institutionalPage -> institutionalPage.getOriginalInstitutionalPageId() != null).findFirst().orElseThrow(() -> InstitutionalPageHelper.foundNotRelatedIPsError((UUID)institutionalPageId, (List)institutionalPages));
    }

    public InstitutionalPageEntity retrieveOriginalForMemberById(UUID userId, UUID institutionalPageId) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        return (InstitutionalPageEntity)this.retrieveAllForMemberWithFilter(userId, (Pageable)PageRequest.of((int)0, (int)1), searchFilters, null, Boolean.valueOf(true)).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public Page<InstitutionalPageEntity> retrieveAllApprovedForMember(UUID userId, Pageable pageable) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().build();
        return this.retrieveAllApprovedForMemberWithFilter(userId, pageable, searchFilters);
    }

    public Page<InstitutionalPageEntity> retrieveAllApprovedForMemberWithFilter(UUID userId, Pageable pageable, SearchForMemberInstitutionalPageModel searchFilters) {
        return this.retrieveAllForMemberWithFilter(userId, pageable, searchFilters, List.of(ModerationStatus.APPROVED), Boolean.valueOf(true));
    }

    public InstitutionalPageEntity retrieveApprovedForMemberById(UUID userId, UUID institutionalPageId) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().includePublishedAndNotMember(Boolean.valueOf(true)).ids(List.of(institutionalPageId)).build();
        return (InstitutionalPageEntity)this.retrieveAllApprovedForMemberWithFilter(userId, (Pageable)PageRequest.of((int)0, (int)1), searchFilters).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public Page<InstitutionalPageEntity> retrieveAllApprovedHierarchyForMemberByRootId(UUID userId, Pageable pageable, UUID rootId) {
        return this.institutionalPageRepository.findHierarchyForMemberFiltered(pageable, userId, rootId, true, List.of(ModerationStatus.APPROVED.getLabel()), true);
    }

    public Page<InstitutionalPageEntity> retrieveAllOriginalInHierarchyByRootId(Pageable pageable, UUID rootId) {
        return this.institutionalPageRepository.findHierarchyFiltered(pageable, rootId, false, null, true);
    }

    public Page<InstitutionalPageEntity> retrieveAllPendingForMember(UUID userId, Pageable pageable) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().build();
        return this.retrieveAllPendingForMemberWithFilter(userId, pageable, searchFilters, null);
    }

    public Page<InstitutionalPageEntity> retrieveAllPendingForMemberWithFilter(UUID userId, Pageable pageable, SearchForMemberInstitutionalPageModel searchFilters, String moderationStatus) {
        List<ModerationStatus> moderationStatuses = moderationStatus != null ? List.of(ModerationStatus.ofLabel((String)moderationStatus)) : List.of(ModerationStatus.PENDING, ModerationStatus.REJECTED);
        return this.retrieveAllForMemberWithFilter(userId, pageable, searchFilters, moderationStatuses, Boolean.valueOf(false));
    }

    public InstitutionalPageEntity retrievePendingForMemberById(UUID userId, UUID institutionalPageId) {
        SearchForMemberInstitutionalPageModel searchFilters = SearchForMemberInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        return (InstitutionalPageEntity)this.retrieveAllPendingForMemberWithFilter(userId, (Pageable)PageRequest.of((int)0, (int)1), searchFilters, null).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public Page<InstitutionalPageEntity> retrieveAllPending(Pageable pageable) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().build();
        return this.retrieveAllPendingWithFilter(pageable, searchFilters, null);
    }

    public Page<InstitutionalPageEntity> retrieveAllPendingWithFilter(Pageable pageable, SearchInstitutionalPageModel searchFilters, String moderationStatus) {
        List<ModerationStatus> moderationStatuses = moderationStatus != null ? List.of(ModerationStatus.ofLabel((String)moderationStatus)) : List.of(ModerationStatus.PENDING, ModerationStatus.REJECTED);
        return this.retrieveAllWithFilter(pageable, searchFilters, moderationStatuses, Boolean.valueOf(false));
    }

    public InstitutionalPageEntity retrievePendingById(UUID institutionalPageId) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        return (InstitutionalPageEntity)this.retrieveAllPendingWithFilter((Pageable)PageRequest.of((int)0, (int)1), searchFilters, null).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public Page<InstitutionalPageEntity> retrieveAllPublished(Pageable pageable) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().published(Boolean.valueOf(true)).build();
        return this.retrieveAllApprovedWithFilter(pageable, searchFilters);
    }

    public InstitutionalPageEntity retrievePublishedById(UUID institutionalPageId) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).published(Boolean.valueOf(true)).build();
        return (InstitutionalPageEntity)this.retrieveAllApprovedWithFilter((Pageable)PageRequest.of((int)0, (int)1), searchFilters).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public List<InstitutionalPageEntity> retrieveAllApprovedByIds(List<UUID> institutionalPageIds) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().ids(institutionalPageIds).build();
        return this.retrieveAllApprovedWithFilter(Pageable.unpaged(), searchFilters).getContent();
    }

    public InstitutionalPageEntity retrieveApprovedById(UUID institutionalPageId) {
        SearchInstitutionalPageModel searchFilters = SearchInstitutionalPageModel.builder().ids(List.of(institutionalPageId)).build();
        return (InstitutionalPageEntity)this.retrieveAllApprovedWithFilter((Pageable)PageRequest.of((int)0, (int)1), searchFilters).stream().findFirst().orElseThrow(() -> new InstitutionalPageNotFoundException(institutionalPageId));
    }

    public Page<InstitutionalPageEntity> retrieveAllApprovedWithFilter(Pageable pageable, SearchInstitutionalPageModel searchFilters) {
        return this.retrieveAllWithFilter(pageable, searchFilters, List.of(ModerationStatus.APPROVED), Boolean.valueOf(true));
    }

    public UUID retrieveRootInstitutionalPageId(UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPage = this.retrieveInstitutionalPage(institutionalPageId);
        return InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
    }

    public InstitutionalPageEntity retrieveRootForMemberById(UUID userId, UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPage = this.retrieveOriginalForMemberById(userId, institutionalPageId);
        return this.retrieveRootInstitutionalPage(institutionalPage);
    }

    public List<InstitutionalPageEntity> retrieveOriginalRootsInstitutionalPages(List<InstitutionalPageEntity> institutionalPages) {
        LinkedList<UUID> institutionalPageIds = new LinkedList<UUID>();
        LinkedList<UUID> rootInstitutionalPageIds = new LinkedList<UUID>();
        HashMap<UUID, InstitutionalPageEntity> existingRootInstitutionalPages = new HashMap<UUID, InstitutionalPageEntity>();
        for (InstitutionalPageEntity institutionalPage : institutionalPages) {
            UUID institutionalPageId = institutionalPage.getId();
            UUID rootId = InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
            if (rootId.equals(institutionalPageId) || existingRootInstitutionalPages.containsKey(institutionalPageId)) {
                existingRootInstitutionalPages.put(institutionalPageId, institutionalPage);
                continue;
            }
            institutionalPageIds.add(institutionalPageId);
            rootInstitutionalPageIds.add(rootId);
        }
        if (rootInstitutionalPageIds.isEmpty()) {
            return new LinkedList<InstitutionalPageEntity>(existingRootInstitutionalPages.values());
        }
        LinkedList<InstitutionalPageEntity> foundRoots = new LinkedList<InstitutionalPageEntity>(this.retrieveAllApprovedByIds(rootInstitutionalPageIds));
        InstitutionalPageHelper.verifyAllRootFoundOrThrow(institutionalPageIds, foundRoots, rootInstitutionalPageIds);
        foundRoots.addAll(existingRootInstitutionalPages.values());
        return foundRoots;
    }

    public List<InstitutionalPageEntity> retrieveApprovedParentsInstitutionalPages(List<InstitutionalPageEntity> institutionalPages) {
        LinkedList<UUID> institutionalPageIds = new LinkedList<UUID>();
        LinkedList parentInstitutionalPageIds = new LinkedList();
        for (InstitutionalPageEntity institutionalPage : institutionalPages) {
            institutionalPageIds.add(institutionalPage.getId());
            Optional.ofNullable(institutionalPage.getParentInstitutionalPageId()).ifPresent(parentId -> parentInstitutionalPageIds.add(parentId));
        }
        if (parentInstitutionalPageIds.isEmpty()) {
            return new LinkedList<InstitutionalPageEntity>();
        }
        List foundParents = this.retrieveAllApprovedByIds(parentInstitutionalPageIds);
        InstitutionalPageHelper.verifyAllParentFoundOrThrow(institutionalPageIds, (List)foundParents, parentInstitutionalPageIds);
        return foundParents;
    }

    public List<InstitutionalPageEntity> retrieveApprovedChildInstitutionalPages(InstitutionalPageEntity institutionalPage) {
        return this.retrieveApprovedChildInstitutionalPages(List.of(institutionalPage));
    }

    public List<InstitutionalPageEntity> retrieveApprovedChildInstitutionalPages(List<InstitutionalPageEntity> institutionalPages) {
        List<UUID> originalInstitutionalPageIds = institutionalPages.stream().map(institutionalPage -> InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPage)).toList();
        return this.institutionalPageRepository.findAllByParentInstitutionalPageIdInAndModerationStatusIn(originalInstitutionalPageIds, List.of(ModerationStatus.APPROVED));
    }

    public List<InstitutionalPageEntity> retrieveOriginalChildInstitutionalPages(InstitutionalPageEntity institutionalPage) {
        UUID originalInstitutionalPageId = InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
        return this.institutionalPageRepository.findAllByParentInstitutionalPageIdAndOriginalInstitutionalPageIdIsNull(originalInstitutionalPageId);
    }

    public InstitutionalPageEntity retrieveOriginalInstitutionalPage(InstitutionalPageEntity institutionalPage) {
        InstitutionalPageEntity originalInstitutionalPage = institutionalPage.getOriginalInstitutionalPageId() != null ? this.retrieveInstitutionalPageOrThrow(institutionalPage.getOriginalInstitutionalPageId(), () -> new WP2BusinessException(InstitutionalPageHelper.getOriginalIPNotFoundErrorMessage((UUID)institutionalPage.getId(), (UUID)institutionalPage.getOriginalInstitutionalPageId()))) : institutionalPage;
        return originalInstitutionalPage;
    }

    public InstitutionalPageEntity retrieveRootInstitutionalPage(InstitutionalPageEntity institutionalPage) {
        InstitutionalPageEntity rootInstitutionalPage;
        if (!CollectionUtils.isEmpty((Collection)institutionalPage.getAncestorInstitutionalPageIds())) {
            UUID rootInstitutionalPageId = (UUID)institutionalPage.getAncestorInstitutionalPageIds().getFirst();
            rootInstitutionalPage = this.retrieveInstitutionalPageOrThrow(rootInstitutionalPageId, () -> new WP2BusinessException(InstitutionalPageHelper.getRootIPNotFoundErrorMessage((UUID)institutionalPage.getId(), (UUID)rootInstitutionalPageId)));
        } else {
            rootInstitutionalPage = this.retrieveOriginalInstitutionalPage(institutionalPage);
        }
        return rootInstitutionalPage;
    }

    public static UUID getOriginalInstitutionalPageId(InstitutionalPageEntity institutionalPageEntity) {
        return Optional.ofNullable(institutionalPageEntity.getOriginalInstitutionalPageId()).orElse(institutionalPageEntity.getId());
    }

    public static UUID getRootInstitutionalPageId(InstitutionalPageEntity institutionalPageEntity) {
        UUID rootInstitutionalPageId = !CollectionUtils.isEmpty((Collection)institutionalPageEntity.getAncestorInstitutionalPageIds()) ? (UUID)institutionalPageEntity.getAncestorInstitutionalPageIds().getFirst() : InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPageEntity);
        return rootInstitutionalPageId;
    }

    private Page<InstitutionalPageEntity> retrieveAllWithFilter(Pageable pageable, SearchInstitutionalPageModel searchFilters, List<ModerationStatus> moderationStatuses, Boolean originalVersionOnly) {
        boolean applyModerationStatusesFilter = !CollectionUtils.isEmpty(moderationStatuses);
        List<String> moderationStatusLabels = applyModerationStatusesFilter ? InstitutionalPageHelper.toStringList(moderationStatuses) : List.of("__IGNORED__");
        boolean applyInstitutionalPageIdsFilter = !CollectionUtils.isEmpty((Collection)searchFilters.getIds());
        List<UUID> institutionalPageIds = applyInstitutionalPageIdsFilter ? searchFilters.getIds() : List.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));
        String searchText = Optional.ofNullable(searchFilters.getSearchText()).map(String::toLowerCase).orElse(null);
        return this.institutionalPageRepository.findAllFiltered(pageable, applyModerationStatusesFilter, moderationStatusLabels, applyInstitutionalPageIdsFilter, institutionalPageIds, searchFilters.getPublished(), searchFilters.getCategory(), searchFilters.getRootLevelOnly() != null && searchFilters.getRootLevelOnly() != false, originalVersionOnly != null && originalVersionOnly != false, searchText);
    }

    private Page<InstitutionalPageEntity> retrieveAllForMemberWithFilter(UUID userId, Pageable pageable, SearchForMemberInstitutionalPageModel searchFilters, List<ModerationStatus> moderationStatuses, Boolean originalVersionOnly) {
        boolean applyModerationStatusesFilter = !CollectionUtils.isEmpty(moderationStatuses);
        List<String> moderationStatusLabels = applyModerationStatusesFilter ? InstitutionalPageHelper.toStringList(moderationStatuses) : List.of("__IGNORED__");
        boolean applyInstitutionalPageIdsFilter = !CollectionUtils.isEmpty((Collection)searchFilters.getIds());
        List<UUID> institutionalPageIds = applyInstitutionalPageIdsFilter ? searchFilters.getIds() : List.of(UUID.fromString("00000000-0000-0000-0000-000000000000"));
        String searchText = Optional.ofNullable(searchFilters.getSearchText()).map(String::toLowerCase).orElse(null);
        return this.institutionalPageRepository.findAllForMemberFiltered(pageable, userId, searchFilters.getWpLeaderOnly() != null && searchFilters.getWpLeaderOnly() != false, applyModerationStatusesFilter, moderationStatusLabels, applyInstitutionalPageIdsFilter, institutionalPageIds, searchFilters.getIncludePrivateAndMember() == null || searchFilters.getIncludePrivateAndMember() != false, searchFilters.getIncludePublishedAndMember() == null || searchFilters.getIncludePublishedAndMember() != false, searchFilters.getIncludePublishedAndNotMember() != null && searchFilters.getIncludePublishedAndNotMember() != false, searchFilters.getCategory(), searchFilters.getRootLevelOnly() != null && searchFilters.getRootLevelOnly() != false, originalVersionOnly != null && originalVersionOnly != false, searchText);
    }

    private static void verifyAllRootFoundOrThrow(List<UUID> institutionalPageIds, List<InstitutionalPageEntity> foundRoots, List<UUID> requestedRootIds) {
        Set foundRootsIds = foundRoots.stream().map(AbstractUUIDEntity::getId).collect(Collectors.toSet());
        HashSet<UUID> notFoundRootIds = new HashSet<UUID>(requestedRootIds);
        notFoundRootIds.removeAll(foundRootsIds);
        if (!notFoundRootIds.isEmpty()) {
            throw new WP2BusinessException(InstitutionalPageHelper.getRootsErrorMessage(institutionalPageIds, notFoundRootIds));
        }
    }

    private static void verifyAllParentFoundOrThrow(List<UUID> institutionalPageIds, List<InstitutionalPageEntity> foundParents, List<UUID> requestedParentIds) {
        Set foundParentsIds = foundParents.stream().map(AbstractUUIDEntity::getId).collect(Collectors.toSet());
        HashSet<UUID> notFoundParentIds = new HashSet<UUID>(requestedParentIds);
        notFoundParentIds.removeAll(foundParentsIds);
        if (!notFoundParentIds.isEmpty()) {
            throw new WP2BusinessException(InstitutionalPageHelper.getParentsErrorMessage(institutionalPageIds, notFoundParentIds));
        }
    }

    private static WP2BusinessException foundNotRelatedIPsError(UUID institutionalPageId, List<InstitutionalPageEntity> institutionalPages) {
        List<UUID> institutionalPageIds = institutionalPages.stream().map(institutionalPageEntity -> institutionalPageEntity.getId()).toList();
        return new WP2BusinessException("found more institutional pages for same id '%s' not related to each other, ids: '%s'".formatted(institutionalPageId, institutionalPageIds));
    }

    private static String getRootIPNotFoundErrorMessage(UUID institutionalPageId, UUID rootInstitutionalPageId) {
        return "InstitutionalPage with id: '%s', rootInstitutionalPage with id: '%s' not found".formatted(institutionalPageId, rootInstitutionalPageId);
    }

    private static String getRootsErrorMessage(List<UUID> institutionalPageIds, Set<UUID> rootInstitutionalPageIds) {
        return "InstitutionalPage with ids: '%s', some rootInstitutionalPage with ids: '%s' not found".formatted(institutionalPageIds, rootInstitutionalPageIds);
    }

    private static String getParentsErrorMessage(List<UUID> institutionalPageIds, Set<UUID> parentInstitutionalPageIds) {
        return "InstitutionalPage with ids: '%s', some parentInstitutionalPage with ids: '%s' not found".formatted(institutionalPageIds, parentInstitutionalPageIds);
    }

    private static String getOriginalIPNotFoundErrorMessage(UUID institutionalPageId, UUID originalInstitutionalPageId) {
        return "InstitutionalPage with id: '%s', originalInstitutionalPage with id: '%s' not found".formatted(institutionalPageId, originalInstitutionalPageId);
    }

    @NotNull
    private static List<String> toStringList(List<ModerationStatus> moderationStatuses) {
        return moderationStatuses.stream().map(moderationStatus -> moderationStatus.getLabel()).toList();
    }

    @Generated
    public InstitutionalPageHelper(InstitutionalPageRepository institutionalPageRepository, MemberRequestHelper memberRequestHelper) {
        this.institutionalPageRepository = institutionalPageRepository;
        this.memberRequestHelper = memberRequestHelper;
    }
}

