/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.impl;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.DtoBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageModerationHandler;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InvalidParagraphPositionException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.ParagraphNotFoundException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ParagraphMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.ParagraphService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultParagraphService
implements ParagraphService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultParagraphService.class);
    private final ParagraphMapper paragraphMapper;
    private final MemberHelper memberHelper;
    private final InstitutionalPageHelper institutionalPageHelper;
    private final DtoBuilder dtoBuilder;
    private final InstitutionalPageModerationHandler institutionalPageModerationHandler;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto addParagraph(@NonNull UUID userId, @NonNull UUID institutionalPageId, Integer position, @NonNull InputParagraphDto inputParagraphDto) {
        int insertPosition;
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity retrievedInstitutionalPage = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPage = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPage);
        List paragraphs = institutionalPage.getParagraphs();
        int n = insertPosition = position != null ? position.intValue() : paragraphs.size();
        if (insertPosition < 0 || insertPosition > paragraphs.size()) {
            throw new InvalidParagraphPositionException(insertPosition, 0, paragraphs.size());
        }
        ParagraphEntity newParagraph = this.paragraphMapper.toEntity(inputParagraphDto);
        newParagraph.setInstitutionalPage(institutionalPage);
        paragraphs.add(insertPosition, newParagraph);
        InstitutionalPageEntity savedInstitutionalPage = this.institutionalPageHelper.save(userId, institutionalPage);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPage);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto updateParagraph(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull UUID paragraphId, @NonNull InputParagraphDto inputParagraphDto) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity retrievedInstitutionalPage = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        ParagraphEntity foundParagraph = retrievedInstitutionalPage.getParagraphs().stream().filter(paragraph -> paragraph.getId().equals(paragraphId)).findFirst().orElseThrow(() -> new ParagraphNotFoundException(paragraphId, institutionalPageId));
        this.paragraphMapper.updateEntity(foundParagraph, inputParagraphDto);
        InstitutionalPageEntity institutionalPage = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPage);
        InstitutionalPageEntity savedInstitutionalPage = this.institutionalPageHelper.save(userId, institutionalPage);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPage);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto removeParagraph(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull UUID paragraphId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity retrievedInstitutionalPage = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        boolean paragraphRemoved = retrievedInstitutionalPage.getParagraphs().removeIf(paragraph -> paragraph.getId().equals(paragraphId));
        if (!paragraphRemoved) {
            throw new ParagraphNotFoundException(paragraphId, institutionalPageId);
        }
        InstitutionalPageEntity institutionalPage = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPage);
        InstitutionalPageEntity savedInstitutionalPage = this.institutionalPageHelper.save(userId, institutionalPage);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPage);
        return outputInstitutionalPageDto;
    }

    @Generated
    public DefaultParagraphService(ParagraphMapper paragraphMapper, MemberHelper memberHelper, InstitutionalPageHelper institutionalPageHelper, DtoBuilder dtoBuilder, InstitutionalPageModerationHandler institutionalPageModerationHandler) {
        this.paragraphMapper = paragraphMapper;
        this.memberHelper = memberHelper;
        this.institutionalPageHelper = institutionalPageHelper;
        this.dtoBuilder = dtoBuilder;
        this.institutionalPageModerationHandler = institutionalPageModerationHandler;
    }
}

