/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.api;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="Paragraphs", description="Operations related to the paragraphs of the institutional pages")
@SecurityRequirement(name="BearerAuth")
public interface ParagraphApi {
    @Operation(summary="Create a paragraph for an institutional page")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs"})
    public ResponseEntity<OutputInstitutionalPageDto> createParagraph(@PathVariable UUID var1, @Valid @RequestBody InputParagraphDto var2, @RequestParam(required=false) Integer var3);

    @Operation(summary="Update a paragraph of an institutional page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"})
    public ResponseEntity<OutputInstitutionalPageDto> updateParagraph(@PathVariable UUID var1, @PathVariable UUID var2, @Valid @RequestBody InputParagraphDto var3);

    @Operation(summary="Delete a paragraph of an institutional page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"})
    public ResponseEntity<OutputInstitutionalPageDto> deleteParagraph(@PathVariable UUID var1, @PathVariable UUID var2);
}

