/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageViewIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InviteMembersIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPInvitationRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestsIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.RemoveMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.SubmitJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.MemberMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationMessageFactory;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.WorkspaceRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.MemberService;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultMemberService
implements MemberService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMemberService.class);
    private static final int INSTITUTIONAL_PAGES_PER_PAGE = 50;
    private final MemberMapper memberMapper;
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final InstitutionalPageProducer institutionalPageProducer;
    private final NotificationMessageFactory notificationMessageFactory;
    private final NotificationProducer notificationProducer;
    private final WorkspaceRepository workspaceRepository;
    private final UserProfileRepository userProfileRepository;

    @NotNull
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(@NotNull UUID institutionalPageId) {
        try {
            PendingMemberRequestsIPDmDto pendingMemberRequestsDmDto = this.institutionalPageDmClient.findPendingMemberRequestsForInstitutionalPage(institutionalPageId);
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser() {
        try {
            PendingMemberRequestsIPDmDto pendingMemberRequestsForUserDmDto = this.institutionalPageDmClient.findPendingMemberRequestsForUser();
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsForUserDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto inviteMembers(@NotNull UUID institutionalPageId, @NotNull InputInviteMembersDto inputInviteMembersDto) {
        try {
            List userProfiles = this.userProfileRepository.getMemberProfilesOrThrow(inputInviteMembersDto.getUserIds());
            InviteMembersIPDmDto inviteMembersIPDmDto = this.memberMapper.toInviteMembersIPDmDto(inputInviteMembersDto);
            PendingMemberRequestsIPDmDto pendingMemberRequestsIPDmDto = this.institutionalPageDmClient.inviteMembers(institutionalPageId, inviteMembersIPDmDto);
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId);
            this.workspaceRepository.shareInstitutionalPageFolderToUsers(institutionalPageIPDmDto.getWorkspaceFolderId(), userProfiles);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createMemberInvitationNotification(institutionalPageIPDmDto, inputInviteMembersDto);
            this.notificationProducer.publishMemberInvitationNotification(notificationMessage);
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsIPDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto cancelInvitation(@NotNull UUID institutionalPageId, @NotNull UUID invitedUserId) {
        try {
            OutputUserProfileDto invitedUserProfile = (OutputUserProfileDto)this.userProfileRepository.getMemberProfilesOrThrow(List.of(invitedUserId)).getFirst();
            PendingMemberRequestsIPDmDto pendingMemberRequestsIPDmDto = this.institutionalPageDmClient.cancelInvitation(institutionalPageId, invitedUserId);
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId);
            UUID newFolderId = this.workspaceRepository.unshareInstitutionalPageFolderFromUsers(institutionalPageIPDmDto.getWorkspaceFolderId(), List.of(invitedUserProfile));
            InstitutionalPageIPDmDto newInstitutionalPageIPDmDto = this.institutionalPageDmClient.updateFolderId(institutionalPageId, newFolderId);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createMemberInvitationDeletedNotification(newInstitutionalPageIPDmDto, invitedUserId);
            this.notificationProducer.publishMemberInvitationDeletedNotification(notificationMessage);
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsIPDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(@NotNull UUID institutionalPageId, @NotNull InputPatchIPInvitationRequestDto inputPatchIPInvitationRequestDto) {
        try {
            Optional<PendingMemberRequestIPDmDto> pendingMemberRequestIPDmDto = this.institutionalPageDmClient.findPendingMemberRequestsForUser().getInvitations().stream().filter(invitation -> invitation.getInstitutionalPage().getId().equals(institutionalPageId)).findAny();
            PatchIPInvitationRequestIPDmDto patchIPInvitationRequestIPDmDto = this.memberMapper.toPatchIPInvitationRequestIPDmDto(inputPatchIPInvitationRequestDto);
            PendingMemberRequestsIPDmDto pendingMemberRequestsDmDto = this.institutionalPageDmClient.acceptOrRejectInvitation(institutionalPageId, patchIPInvitationRequestIPDmDto);
            if (pendingMemberRequestIPDmDto.isEmpty()) {
                throw new WP2BusinessException("Invitation accepted/rejected successfully, but didn't find invitation fields");
            }
            Boolean wpLeader = pendingMemberRequestIPDmDto.get().getWpLeader();
            InstitutionalPageIPDmDto institutionalPageIPDmDto = pendingMemberRequestIPDmDto.get().getInstitutionalPage();
            List hierarchyInstitutionalPages = List.of();
            if (inputPatchIPInvitationRequestDto.getApproved().booleanValue()) {
                InstitutionalPageIPDmDto updatedInstitutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId);
                OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(updatedInstitutionalPageIPDmDto, true);
                this.institutionalPageProducer.publishUpdateEvent(institutionalPageDto);
                if (wpLeader != null && wpLeader.booleanValue()) {
                    hierarchyInstitutionalPages = this.getAllChildInstitutionalPages(updatedInstitutionalPageIPDmDto.getRootInstitutionalPageId());
                }
            }
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createMemberInvitationStatusChangeNotification(institutionalPageIPDmDto, inputPatchIPInvitationRequestDto, wpLeader, hierarchyInstitutionalPages);
            this.notificationProducer.publishMemberInvitationStatusChangeNotification(notificationMessage);
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(@NotNull UUID institutionalPageId, @NotNull InputPatchMembershipDto inputPatchMembershipDto) {
        try {
            InstitutionalPageIPDmDto institutionalPageIPDmDto;
            this.userProfileRepository.getMemberProfilesOrThrow(List.of(inputPatchMembershipDto.getUserId()));
            List institutionalPageHierarchy = List.of();
            if (!inputPatchMembershipDto.getWpLeader().booleanValue() && (institutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId)).getWpLeads().contains(inputPatchMembershipDto.getUserId())) {
                institutionalPageHierarchy = this.getAllChildInstitutionalPages(institutionalPageIPDmDto.getRootInstitutionalPageId());
            }
            PatchMembershipIPDmDto patchMembershipIPDmDto = this.memberMapper.toPatchMembershipIPDmDto(inputPatchMembershipDto);
            InstitutionalPageIPDmDto institutionalPageIPDmDto2 = this.institutionalPageDmClient.patchMembershipOfUsersForInstitutionalPage(institutionalPageId, patchMembershipIPDmDto);
            if (inputPatchMembershipDto.getWpLeader().booleanValue()) {
                institutionalPageHierarchy = this.getAllChildInstitutionalPages(institutionalPageIPDmDto2.getRootInstitutionalPageId());
            }
            OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto2, true);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createMembershipChangeNotification(inputPatchMembershipDto, institutionalPageDto, institutionalPageHierarchy);
            this.notificationProducer.publishMembershipChangeNotification(notificationMessage);
            this.institutionalPageProducer.publishUpdateEvent(institutionalPageDto);
            institutionalPageHierarchy.forEach(arg_0 -> ((InstitutionalPageProducer)this.institutionalPageProducer).publishUpdateEvent(arg_0));
            return institutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(@NotNull UUID institutionalPageId, @NotNull InputRemoveMembershipDto inputRemoveMembershipDto) {
        try {
            this.userProfileRepository.getMemberProfilesOrThrow(List.of(inputRemoveMembershipDto.getUserId()));
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId);
            boolean wpLeader = institutionalPageIPDmDto.getWpLeads().contains(inputRemoveMembershipDto.getUserId());
            List hierarchyInstitutionalPages = List.of();
            if (wpLeader) {
                hierarchyInstitutionalPages = this.getAllChildInstitutionalPages(institutionalPageIPDmDto.getRootInstitutionalPageId());
            }
            RemoveMembershipIPDmDto removeMembershipIPDmDto = this.memberMapper.toRemoveMembershipIPDmDto(inputRemoveMembershipDto);
            institutionalPageIPDmDto = this.institutionalPageDmClient.removeMembershipOfUsersForInstitutionalPage(institutionalPageId, removeMembershipIPDmDto);
            OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createMembershipRemovalNotification(inputRemoveMembershipDto, wpLeader, institutionalPageDto, hierarchyInstitutionalPages);
            this.notificationProducer.publishMembershipRemovalNotification(notificationMessage);
            if (wpLeader) {
                hierarchyInstitutionalPages.forEach(arg_0 -> ((InstitutionalPageProducer)this.institutionalPageProducer).publishUpdateEvent(arg_0));
            } else {
                this.institutionalPageProducer.publishUpdateEvent(institutionalPageDto);
            }
            return institutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto submitJoinRequest(@NotNull UUID institutionalPageId, @NotNull InputSubmitJoinRequestDto inputSubmitJoinRequestDto) {
        try {
            SubmitJoinRequestIPDmDto submitJoinRequestIPDmDto = this.memberMapper.toSubmitJoinRequestIPDmDto(inputSubmitJoinRequestDto);
            PendingMemberRequestsIPDmDto pendingMemberRequestsIPDmDto = this.institutionalPageDmClient.submitJoinRequest(institutionalPageId, submitJoinRequestIPDmDto);
            OutputPendingMemberRequestsDto pendingRequests = this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsIPDmDto);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createJoinRequestNotification(institutionalPageId, inputSubmitJoinRequestDto, pendingRequests);
            this.notificationProducer.publishJoinRequestNotification(notificationMessage);
            return pendingRequests;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto cancelJoinRequest(@NotNull UUID institutionalPageId) {
        try {
            PendingMemberRequestsIPDmDto pendingMemberRequestsIPDmDto = this.institutionalPageDmClient.cancelJoinRequest(institutionalPageId);
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId, InstitutionalPageViewIPDmDto.APPROVED, Boolean.valueOf(true));
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createJoinRequestDeletedNotification(institutionalPageIPDmDto);
            this.notificationProducer.publishJoinRequestDeletedNotification(notificationMessage);
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsIPDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(@NotNull UUID institutionalPageId, @NotNull InputPatchIPJoinRequestDto inputPatchIPJoinRequestDto) {
        try {
            List userProfiles = this.userProfileRepository.getMemberProfilesOrThrow(inputPatchIPJoinRequestDto.getUserIds());
            PatchIPJoinRequestIPDmDto patchIPJoinRequestIPDmDto = this.memberMapper.toPatchIPJoinRequestIPDmDto(inputPatchIPJoinRequestDto);
            PendingMemberRequestsIPDmDto pendingMemberRequestsIPDmDto = this.institutionalPageDmClient.acceptOrRejectJoinRequests(institutionalPageId, patchIPJoinRequestIPDmDto);
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.retrieveOriginalInstitutionalPageById(institutionalPageId);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createJoinRequestStatusChangeNotification(institutionalPageIPDmDto, inputPatchIPJoinRequestDto);
            this.notificationProducer.publishJoinRequestStatusChangeNotification(notificationMessage);
            if (inputPatchIPJoinRequestDto.getApproved().booleanValue()) {
                OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true);
                this.institutionalPageProducer.publishUpdateEvent(institutionalPageDto);
                this.workspaceRepository.shareInstitutionalPageFolderToUsers(institutionalPageDto.getWorkspaceFolderId(), userProfiles);
            }
            return this.memberMapper.toOutputPendingMemberRequestsDto(pendingMemberRequestsIPDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NotNull
    public OutputPageDto<OutputMembersInHierarchyDto> findAllUsersInHierarchy(@NotNull UUID rootInstitutionalPageId, int pageNumber, int pageSize) {
        try {
            OutputPageDto membersInHierarchyIPDmDtoPage = this.institutionalPageDmClient.findAllUsersInHierarchy(rootInstitutionalPageId, pageNumber, pageSize);
            return this.memberMapper.toOutputMembersInHierarchyDto(membersInHierarchyIPDmDtoPage);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e.getMessage());
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(rootInstitutionalPageId);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    private List<OutputInstitutionalPageDto> getAllChildInstitutionalPages(UUID institutionalPageId) {
        int pageNo = 0;
        int pageSize = 50;
        ArrayList<OutputInstitutionalPageDto> childInstitutionalPages = new ArrayList<OutputInstitutionalPageDto>();
        try {
            OutputPageDto institutionalPagesPage = this.institutionalPageDmClient.findInstitutionalPagesHierarchyByRootId(institutionalPageId, Set.of("all"), pageNo, pageSize, "name", SortDirection.ASC);
            long fetched = institutionalPagesPage.getContent().size();
            institutionalPagesPage.getContent().stream().map(institutionalPageIPDmDto -> this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true)).forEach(childInstitutionalPages::add);
            while (fetched == (long)pageSize) {
                ++pageNo;
                try {
                    institutionalPagesPage = this.institutionalPageDmClient.findInstitutionalPagesHierarchyByRootId(institutionalPageId, Set.of("all"), pageNo, pageSize, "name", SortDirection.ASC);
                    fetched = institutionalPagesPage.getContent().size();
                    institutionalPagesPage.getContent().stream().map(institutionalPageIPDmDto -> this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true)).forEach(childInstitutionalPages::add);
                }
                catch (FeignException.NotFound ex) {
                    log.warn("No child institutional pages found for page number - {}", (Object)pageNo, (Object)ex);
                    break;
                }
            }
        }
        catch (FeignException.NotFound ex) {
            log.warn("No child institutional pages found", (Throwable)ex);
        }
        return childInstitutionalPages;
    }

    private InstitutionalPageIPDmDto retrieveOriginalInstitutionalPageById(UUID institutionalPageId) {
        return this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId, InstitutionalPageViewIPDmDto.ORIGINAL, Boolean.valueOf(false));
    }

    @Generated
    public DefaultMemberService(MemberMapper memberMapper, InstitutionalPageMapper institutionalPageMapper, InstitutionalPageDmClient institutionalPageDmClient, InstitutionalPageProducer institutionalPageProducer, NotificationMessageFactory notificationMessageFactory, NotificationProducer notificationProducer, WorkspaceRepository workspaceRepository, UserProfileRepository userProfileRepository) {
        this.memberMapper = memberMapper;
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.institutionalPageProducer = institutionalPageProducer;
        this.notificationMessageFactory = notificationMessageFactory;
        this.notificationProducer = notificationProducer;
        this.workspaceRepository = workspaceRepository;
        this.userProfileRepository = userProfileRepository;
    }
}

