package com.finconsgroup.itserr.marketplace.institutional_page.bs.validation;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Pattern;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_IP_ASSOCIATIONS_ALLOWED_VALUES;

/**
 * Meta-annotation to apply a regex pattern for associations to load input parameter.
 */
@Documented
@Constraint(validatedBy = {})
@Target({ElementType.TYPE_USE, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Pattern(regexp = "all|parentInstitutionalPage|wpLeads|members|childInstitutionalPages|paragraphs")
public @interface ValidAssociationToLoad {

    String message() default VALIDATION_ERROR_FIELD_IP_ASSOCIATIONS_ALLOWED_VALUES;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
