package com.finconsgroup.itserr.marketplace.institutional_page.bs.repository;

import com.finconsgroup.itserr.marketplace.catalog.bs.client.ItemClient;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.ItemStatus;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.PublicationMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.UUID;

/**
 * Repository class for handling catalog-related operations and data access.
 */
@Component
@RequiredArgsConstructor
public class CatalogRepository {

    private final ItemClient itemClient;
    private final PublicationMapper publicationMapper;

    public List<OutputPublicationDto> getPublications(UUID institutionalPageId) {
        List<OutputPublicationDto> publications = itemClient.getAllItems(
                        0, Integer.MAX_VALUE, null, null,
                        null, null, null, null, ItemStatus.APPROVED,
                        institutionalPageId)
                .map(publicationMapper::toOutputPublicationDto)
                .getContent();
        return publications;
    }
}
