package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

@Schema(name = "OutputPublicationDto", description = "Output DTO of a publication")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OutputPublicationDto {
    private UUID id;

    private String title;
    private String description;

    private String status;

    private List<OutputPublicationAuthorDto> authors;
    private OutputPublicationUserProfileDto maintainer;

    private Instant createdAt;
    private Instant updatedAt;

    private String type;

    private String imageUrl;

    private String license;

    private LocalDateTime publicationDate;

    private List<String> tags;

    private String language;
}
