package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Map;
import java.util.UUID;

/**
 * Output DTO representing document metadata.
 */
@Schema(name = "OutputDocumentMetadataDto", description = "Output DTO representing document metadata")
@Data
@Builder
@AllArgsConstructor
public class OutputDocumentMetadataDto {

    @Schema(
            description = "Metadata id",
            example = "3ca8a207-48a0-45ef-85be-d525d80585b1")
    private UUID id;

    @Schema(
            description = "Metadata fields.",
            example = """
                    {
                      "field1": "A STRING",
                      "field2": 12345,
                      "field3": {
                        "subfield1": "AAA",
                        "subfield2": "BBB"
                      }
                    }
                    """
    )
    private Map<String, Object> fields;

}
