package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * Input DTO of supported operating systems for the institutional page.
 */
@Schema(
        name = "InputSupportedOsDto",
        description = "Input DTO of supported operating systems for the institutional page"
)
@Data
@Builder
@AllArgsConstructor
public class InputSupportedOsDto {

    @Schema(description = "The supported macOS version or description.", example = "macOS 12+ supported")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String macOs;

    @Schema(description = "The supported linux version or description.", example = "Ubuntu 20.04+")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String linux;

    @Schema(description = "The supported windows version or description.", example = "Windows 10+ supported")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String windows;

}
