package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;


/**
 * Input DTO for removing user membership for an institutional page.
 */
@Schema(name = "InputRemoveMembershipDto", description = "Input DTO for removing user membership for an institutional page")
@Data
@Builder
@AllArgsConstructor
public class InputRemoveMembershipDto {

    @Schema(
            description = "ID of user to remove membership",
            example = "33333333-aaaa-1111-0000-000000000000"
    )
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private UUID userId;

}
