package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutional_page.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO to approve or reject an invitation to an Institutional Page.
 */
@Schema(
        name = "InputPatchIPInvitationRequestDto",
        description = "Input DTO to approve or reject invitation to an Institutional Page"
)
@Data
@Builder
@AllArgsConstructor
public class InputPatchIPInvitationRequestDto {

    @Schema(description = "Specify whether to approve or reject the pending member request", example = "true")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private Boolean approved;

    @Schema(description = "The rejection message", example = "I am not available for contributing to Institutional Pages")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String message;

}
