package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.MemberApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.MemberService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling Member related API requests.
 *
 * <p>Implements the {@link MemberApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class MemberController implements MemberApi {

    private final MemberService memberService;

    @Override
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(
            final UUID institutionalPageId
    ) {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/{}/members/requests", institutionalPageId);
        return this.memberService.findPendingMemberRequestsForInstitutionalPage(institutionalPageId);
    }

    @Override
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser() {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/members/requests");
        return this.memberService.findPendingMemberRequestsForUser();
    }

    @Override
    public OutputPendingMemberRequestsDto inviteMembers(
            final UUID institutionalPageId,
            final InputInviteMembersDto inputInviteMembersDto
    ) {
        log.debug("POST /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations, inputInviteMembersDto: {}", institutionalPageId, inputInviteMembersDto);
        return this.memberService.inviteMembers(institutionalPageId, inputInviteMembersDto);
    }

    @Override
    public OutputPendingMemberRequestsDto cancelInvitation(
            final UUID institutionalPageId,
            final UUID invitedUserId
    ) {
        log.debug("DELETE /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations/{}", institutionalPageId, invitedUserId);
        return this.memberService.cancelInvitation(institutionalPageId, invitedUserId);
    }

    @Override
    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(
            final UUID institutionalPageId,
            final InputPatchIPInvitationRequestDto inputPatchIPInvitationRequestDto
    ) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/invitations, inputPatchIPInvitationRequestDto: {}", institutionalPageId, inputPatchIPInvitationRequestDto);
        return this.memberService.acceptOrRejectInvitation(institutionalPageId, inputPatchIPInvitationRequestDto);
    }

    @Override
    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(
            final UUID institutionalPageId,
            final InputPatchMembershipDto inputPatchMembershipDto
    ) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/membership, inputPatchMembershipDto: {}", institutionalPageId, inputPatchMembershipDto);
        return this.memberService.patchMembershipOfUsersForInstitutionalPage(institutionalPageId, inputPatchMembershipDto);
    }

    @Override
    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(
            final UUID institutionalPageId,
            final InputRemoveMembershipDto inputRemoveMembershipDto
    ) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/members/membership, inputRemoveMembershipDto: {}", institutionalPageId, inputRemoveMembershipDto);
        return this.memberService.removeMembershipOfUsersForInstitutionalPage(institutionalPageId, inputRemoveMembershipDto);
    }

    @Override
    public OutputPendingMemberRequestsDto submitJoinRequest(
            final UUID institutionalPageId,
            final InputSubmitJoinRequestDto inputSubmitJoinRequestDto
    ) {
        log.debug("POST /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join, inputSubmitJoinRequestDto: {}", institutionalPageId, inputSubmitJoinRequestDto);
        return this.memberService.submitJoinRequest(institutionalPageId, inputSubmitJoinRequestDto);
    }

    @Override
    public OutputPendingMemberRequestsDto cancelJoinRequest(final UUID institutionalPageId) {
        log.debug("DELETE /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join", institutionalPageId);
        return this.memberService.cancelJoinRequest(institutionalPageId);
    }

    @Override
    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(
            final UUID institutionalPageId,
            final InputPatchIPJoinRequestDto inputPatchIPJoinRequestDto
    ) {
        log.debug("PATCH /api/v1/bs/institutional-page/institutional-pages/{}/members/requests/join, inputPatchIPJoinRequestDto: {}", institutionalPageId, inputPatchIPJoinRequestDto);
        return this.memberService.acceptOrRejectJoinRequests(institutionalPageId, inputPatchIPJoinRequestDto);
    }

    @Override
    public OutputPageDto<OutputMembersInHierarchyDto> findAllUsersInHierarchy(
            final UUID rootInstitutionalPageId,
            final int pageNumber,
            final int pageSize
    ) {
        log.debug("GET /api/v1/bs/institutional-page/institutional-pages/{}/members/hierarchy, pageNumber: {}, pageSize: {}", rootInstitutionalPageId, pageNumber, pageSize);
        return this.memberService.findAllUsersInHierarchy(rootInstitutionalPageId, pageNumber, pageSize);
    }

}
