package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.UUID;

/**
 * Favourite User Item response dto.
 */
@SuperBuilder(toBuilder = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OutputFavouriteUserItemDto {

    @Schema(
        description = "Favourite User Item Id",
        example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID id;

    @Schema(
        description = "Item context",
        example = "catalog")
    private ItemContext context;

    @Schema(
        description = "Item subcontext",
        example = "dataset")
    private String subContext;

    @Schema(
        description = "Item Id",
        example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private String itemId;

    @Schema(
        description = "Followed",
        example = "true")
    private boolean followed;

    @Schema(
        description = "Created At",
        example = "2025-05-26T14:19:46.606883Z")
    private Instant creationTime;

    @Schema(
        description = "Last Updated At",
        example = "2025-05-27T14:19:46.606883Z")
    private Instant updateTime;
}
