package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.OutputInstitutionalPageFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.people.OutputPeopleFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.search.OutputCatalogFavouriteDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * Favourite User Item Detail response dto.
 *
 * @param <T> The type of detail object
 */
// Using a different builder method name to avoid - name clash: <T>builder() error
@SuperBuilder(builderMethodName = "detailBuilder")
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class OutputFavouriteUserItemDetailDto<T> extends OutputFavouriteUserItemDto {

    @Schema(
        description = "Item Detail",
        oneOf = {
            OutputCatalogFavouriteDto.class,
            OutputInstitutionalPageFavouriteDto.class,
            OutputPeopleFavouriteDto.class
        })
    private T itemDetail;
}
