package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputLocationDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputLocationDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-01-02T20:40:21+0100",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.8 (Oracle Corporation)"
)
@Component
public class ScheduleMapperImpl implements ScheduleMapper {

    @Autowired
    private ProgramMapper programMapper;

    @Override
    public ScheduleEntity toEntity(InputScheduleDto inputScheduleDto) {
        if ( inputScheduleDto == null ) {
            return null;
        }

        ScheduleEntity.ScheduleEntityBuilder<?, ?> scheduleEntity = ScheduleEntity.builder();

        scheduleEntity.locationCity( inputScheduleDtoLocationCity( inputScheduleDto ) );
        scheduleEntity.locationRegion( inputScheduleDtoLocationRegion( inputScheduleDto ) );
        scheduleEntity.locationCountry( inputScheduleDtoLocationCountry( inputScheduleDto ) );
        scheduleEntity.locationZipCode( inputScheduleDtoLocationZipCode( inputScheduleDto ) );
        scheduleEntity.title( inputScheduleDto.getTitle() );
        scheduleEntity.description( inputScheduleDto.getDescription() );
        scheduleEntity.startDate( inputScheduleDto.getStartDate() );
        scheduleEntity.startTime( inputScheduleDto.getStartTime() );
        scheduleEntity.endTime( inputScheduleDto.getEndTime() );
        scheduleEntity.programs( inputProgramDtoListToProgramEntityList( inputScheduleDto.getPrograms() ) );

        return scheduleEntity.build();
    }

    @Override
    public List<ScheduleEntity> toEntityList(List<InputScheduleDto> inputScheduleDto) {
        if ( inputScheduleDto == null ) {
            return null;
        }

        List<ScheduleEntity> list = new ArrayList<ScheduleEntity>( inputScheduleDto.size() );
        for ( InputScheduleDto inputScheduleDto1 : inputScheduleDto ) {
            list.add( toEntity( inputScheduleDto1 ) );
        }

        return list;
    }

    @Override
    public OutputScheduleDto toDto(ScheduleEntity scheduleEntity) {
        if ( scheduleEntity == null ) {
            return null;
        }

        OutputScheduleDto.OutputScheduleDtoBuilder<?, ?> outputScheduleDto = OutputScheduleDto.builder();

        outputScheduleDto.location( scheduleEntityToOutputLocationDto( scheduleEntity ) );
        outputScheduleDto.id( scheduleEntity.getId() );
        outputScheduleDto.title( scheduleEntity.getTitle() );
        outputScheduleDto.description( scheduleEntity.getDescription() );
        outputScheduleDto.startDate( scheduleEntity.getStartDate() );
        outputScheduleDto.startTime( scheduleEntity.getStartTime() );
        outputScheduleDto.endTime( scheduleEntity.getEndTime() );
        outputScheduleDto.programs( programEntityListToOutputProgramDtoList( scheduleEntity.getPrograms() ) );

        return outputScheduleDto.build();
    }

    @Override
    public void updateEntity(InputScheduleDto dto, ScheduleEntity scheduleEntity) {
        if ( dto == null ) {
            return;
        }

        scheduleEntity.setLocationCity( inputScheduleDtoLocationCity( dto ) );
        scheduleEntity.setLocationRegion( inputScheduleDtoLocationRegion( dto ) );
        scheduleEntity.setLocationCountry( inputScheduleDtoLocationCountry( dto ) );
        scheduleEntity.setLocationZipCode( inputScheduleDtoLocationZipCode( dto ) );
        scheduleEntity.setTitle( dto.getTitle() );
        scheduleEntity.setDescription( dto.getDescription() );
        scheduleEntity.setStartDate( dto.getStartDate() );
        scheduleEntity.setStartTime( dto.getStartTime() );
        scheduleEntity.setEndTime( dto.getEndTime() );
    }

    private String inputScheduleDtoLocationCity(InputScheduleDto inputScheduleDto) {
        InputLocationDto location = inputScheduleDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getCity();
    }

    private String inputScheduleDtoLocationRegion(InputScheduleDto inputScheduleDto) {
        InputLocationDto location = inputScheduleDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getRegion();
    }

    private String inputScheduleDtoLocationCountry(InputScheduleDto inputScheduleDto) {
        InputLocationDto location = inputScheduleDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getCountry();
    }

    private String inputScheduleDtoLocationZipCode(InputScheduleDto inputScheduleDto) {
        InputLocationDto location = inputScheduleDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getZipCode();
    }

    protected List<ProgramEntity> inputProgramDtoListToProgramEntityList(List<InputProgramDto> list) {
        if ( list == null ) {
            return null;
        }

        List<ProgramEntity> list1 = new ArrayList<ProgramEntity>( list.size() );
        for ( InputProgramDto inputProgramDto : list ) {
            list1.add( programMapper.toEntity( inputProgramDto ) );
        }

        return list1;
    }

    protected OutputLocationDto scheduleEntityToOutputLocationDto(ScheduleEntity scheduleEntity) {
        if ( scheduleEntity == null ) {
            return null;
        }

        OutputLocationDto.OutputLocationDtoBuilder<?, ?> outputLocationDto = OutputLocationDto.builder();

        outputLocationDto.city( scheduleEntity.getLocationCity() );
        outputLocationDto.region( scheduleEntity.getLocationRegion() );
        outputLocationDto.country( scheduleEntity.getLocationCountry() );
        outputLocationDto.zipCode( scheduleEntity.getLocationZipCode() );

        return outputLocationDto.build();
    }

    protected List<OutputProgramDto> programEntityListToOutputProgramDtoList(List<ProgramEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputProgramDto> list1 = new ArrayList<OutputProgramDto>( list.size() );
        for ( ProgramEntity programEntity : list ) {
            list1.add( programMapper.toDto( programEntity ) );
        }

        return list1;
    }
}
