/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.event.dm.dto;

import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputImageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputEventDto", description="DTO representing a event in responses")
public class OutputEventDto {
    @Schema(description="Unique identifier of the event", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="The title of the event", example="Annual Tech Conference 2025")
    private String title;
    @Schema(description="The link for the event", example="https://meeting.example.com/test123")
    private String eventLink;
    @Schema(description="The type of event", example="webinar")
    private String eventType;
    @Schema(description="The content of the event", example="Join us for the biggest tech conference of the year...")
    private String content;
    @Schema(description="The number of participants subscribed for the event", example="10")
    private Integer subscribedParticipantsCount;
    @Schema(description="List of tags associated with the event", example="[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;
    @Schema(description="List of institutional pages")
    private List<OutputInstitutionalPageDto> institutionalPages;
    @Schema(description="The image for the event")
    private OutputImageDto image;
    @Schema(description="The timezone for the event", example="Europe/Rome")
    private String timezone;
    @Schema(description="The start date for the event based on schedules", example="2025-06-18")
    private LocalDate startDate;
    @Schema(description="The end date for the event based on schedules", example="2025-06-20")
    private LocalDate endDate;
    @Schema(description="The event conductors")
    private List<OutputEventConductorDto> eventConductors;
    @Schema(description="The event schedules")
    private List<OutputScheduleDto> schedules;
    @Schema(description="List of subscribed participants")
    private List<OutputSubscribedParticipantDto> subscribedParticipants;
    @Schema(description="The event planner user id")
    private UUID eventPlannerId;
    @Schema(description="The maintainer id")
    private UUID maintainerId;
    @Schema(description="True, if user is subscribed to the event")
    private Boolean subscribed;
    @Schema(description="The creation time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant creationTime;
    @Schema(description="The last update time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant updateTime;

    @Generated
    protected OutputEventDto(OutputEventDtoBuilder<?, ?> b) {
        this.id = b.id;
        this.title = b.title;
        this.eventLink = b.eventLink;
        this.eventType = b.eventType;
        this.content = b.content;
        this.subscribedParticipantsCount = b.subscribedParticipantsCount;
        this.tags = b.tags;
        this.institutionalPages = b.institutionalPages;
        this.image = b.image;
        this.timezone = b.timezone;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.eventConductors = b.eventConductors;
        this.schedules = b.schedules;
        this.subscribedParticipants = b.subscribedParticipants;
        this.eventPlannerId = b.eventPlannerId;
        this.maintainerId = b.maintainerId;
        this.subscribed = b.subscribed;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
    }

    @Generated
    public static OutputEventDtoBuilder<?, ?> builder() {
        return new OutputEventDtoBuilderImpl();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getEventLink() {
        return this.eventLink;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Integer getSubscribedParticipantsCount() {
        return this.subscribedParticipantsCount;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<OutputInstitutionalPageDto> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public OutputImageDto getImage() {
        return this.image;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Generated
    public List<OutputEventConductorDto> getEventConductors() {
        return this.eventConductors;
    }

    @Generated
    public List<OutputScheduleDto> getSchedules() {
        return this.schedules;
    }

    @Generated
    public List<OutputSubscribedParticipantDto> getSubscribedParticipants() {
        return this.subscribedParticipants;
    }

    @Generated
    public UUID getEventPlannerId() {
        return this.eventPlannerId;
    }

    @Generated
    public UUID getMaintainerId() {
        return this.maintainerId;
    }

    @Generated
    public Boolean getSubscribed() {
        return this.subscribed;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setEventLink(String eventLink) {
        this.eventLink = eventLink;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setSubscribedParticipantsCount(Integer subscribedParticipantsCount) {
        this.subscribedParticipantsCount = subscribedParticipantsCount;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<OutputInstitutionalPageDto> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImage(OutputImageDto image) {
        this.image = image;
    }

    @Generated
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Generated
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setEventConductors(List<OutputEventConductorDto> eventConductors) {
        this.eventConductors = eventConductors;
    }

    @Generated
    public void setSchedules(List<OutputScheduleDto> schedules) {
        this.schedules = schedules;
    }

    @Generated
    public void setSubscribedParticipants(List<OutputSubscribedParticipantDto> subscribedParticipants) {
        this.subscribedParticipants = subscribedParticipants;
    }

    @Generated
    public void setEventPlannerId(UUID eventPlannerId) {
        this.eventPlannerId = eventPlannerId;
    }

    @Generated
    public void setMaintainerId(UUID maintainerId) {
        this.maintainerId = maintainerId;
    }

    @Generated
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputEventDto)) {
            return false;
        }
        OutputEventDto other = (OutputEventDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        Integer other$subscribedParticipantsCount = other.getSubscribedParticipantsCount();
        if (this$subscribedParticipantsCount == null ? other$subscribedParticipantsCount != null : !((Object)this$subscribedParticipantsCount).equals(other$subscribedParticipantsCount)) {
            return false;
        }
        Boolean this$subscribed = this.getSubscribed();
        Boolean other$subscribed = other.getSubscribed();
        if (this$subscribed == null ? other$subscribed != null : !((Object)this$subscribed).equals(other$subscribed)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$eventLink = this.getEventLink();
        String other$eventLink = other.getEventLink();
        if (this$eventLink == null ? other$eventLink != null : !this$eventLink.equals(other$eventLink)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<OutputInstitutionalPageDto> this$institutionalPages = this.getInstitutionalPages();
        List<OutputInstitutionalPageDto> other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        OutputImageDto this$image = this.getImage();
        OutputImageDto other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        List<OutputEventConductorDto> this$eventConductors = this.getEventConductors();
        List<OutputEventConductorDto> other$eventConductors = other.getEventConductors();
        if (this$eventConductors == null ? other$eventConductors != null : !((Object)this$eventConductors).equals(other$eventConductors)) {
            return false;
        }
        List<OutputScheduleDto> this$schedules = this.getSchedules();
        List<OutputScheduleDto> other$schedules = other.getSchedules();
        if (this$schedules == null ? other$schedules != null : !((Object)this$schedules).equals(other$schedules)) {
            return false;
        }
        List<OutputSubscribedParticipantDto> this$subscribedParticipants = this.getSubscribedParticipants();
        List<OutputSubscribedParticipantDto> other$subscribedParticipants = other.getSubscribedParticipants();
        if (this$subscribedParticipants == null ? other$subscribedParticipants != null : !((Object)this$subscribedParticipants).equals(other$subscribedParticipants)) {
            return false;
        }
        UUID this$eventPlannerId = this.getEventPlannerId();
        UUID other$eventPlannerId = other.getEventPlannerId();
        if (this$eventPlannerId == null ? other$eventPlannerId != null : !((Object)this$eventPlannerId).equals(other$eventPlannerId)) {
            return false;
        }
        UUID this$maintainerId = this.getMaintainerId();
        UUID other$maintainerId = other.getMaintainerId();
        if (this$maintainerId == null ? other$maintainerId != null : !((Object)this$maintainerId).equals(other$maintainerId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputEventDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $subscribedParticipantsCount = this.getSubscribedParticipantsCount();
        result = result * 59 + ($subscribedParticipantsCount == null ? 43 : ((Object)$subscribedParticipantsCount).hashCode());
        Boolean $subscribed = this.getSubscribed();
        result = result * 59 + ($subscribed == null ? 43 : ((Object)$subscribed).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $eventLink = this.getEventLink();
        result = result * 59 + ($eventLink == null ? 43 : $eventLink.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<OutputInstitutionalPageDto> $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        OutputImageDto $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        List<OutputEventConductorDto> $eventConductors = this.getEventConductors();
        result = result * 59 + ($eventConductors == null ? 43 : ((Object)$eventConductors).hashCode());
        List<OutputScheduleDto> $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : ((Object)$schedules).hashCode());
        List<OutputSubscribedParticipantDto> $subscribedParticipants = this.getSubscribedParticipants();
        result = result * 59 + ($subscribedParticipants == null ? 43 : ((Object)$subscribedParticipants).hashCode());
        UUID $eventPlannerId = this.getEventPlannerId();
        result = result * 59 + ($eventPlannerId == null ? 43 : ((Object)$eventPlannerId).hashCode());
        UUID $maintainerId = this.getMaintainerId();
        result = result * 59 + ($maintainerId == null ? 43 : ((Object)$maintainerId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputEventDto(id=" + String.valueOf(this.getId()) + ", title=" + this.getTitle() + ", eventLink=" + this.getEventLink() + ", eventType=" + this.getEventType() + ", content=" + this.getContent() + ", subscribedParticipantsCount=" + this.getSubscribedParticipantsCount() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", image=" + String.valueOf(this.getImage()) + ", timezone=" + this.getTimezone() + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", eventConductors=" + String.valueOf(this.getEventConductors()) + ", schedules=" + String.valueOf(this.getSchedules()) + ", subscribedParticipants=" + String.valueOf(this.getSubscribedParticipants()) + ", eventPlannerId=" + String.valueOf(this.getEventPlannerId()) + ", maintainerId=" + String.valueOf(this.getMaintainerId()) + ", subscribed=" + this.getSubscribed() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public OutputEventDto() {
    }

    @Generated
    public OutputEventDto(UUID id, String title, String eventLink, String eventType, String content, Integer subscribedParticipantsCount, List<String> tags, List<OutputInstitutionalPageDto> institutionalPages, OutputImageDto image, String timezone, LocalDate startDate, LocalDate endDate, List<OutputEventConductorDto> eventConductors, List<OutputScheduleDto> schedules, List<OutputSubscribedParticipantDto> subscribedParticipants, UUID eventPlannerId, UUID maintainerId, Boolean subscribed, Instant creationTime, Instant updateTime) {
        this.id = id;
        this.title = title;
        this.eventLink = eventLink;
        this.eventType = eventType;
        this.content = content;
        this.subscribedParticipantsCount = subscribedParticipantsCount;
        this.tags = tags;
        this.institutionalPages = institutionalPages;
        this.image = image;
        this.timezone = timezone;
        this.startDate = startDate;
        this.endDate = endDate;
        this.eventConductors = eventConductors;
        this.schedules = schedules;
        this.subscribedParticipants = subscribedParticipants;
        this.eventPlannerId = eventPlannerId;
        this.maintainerId = maintainerId;
        this.subscribed = subscribed;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }

    @Generated
    public static abstract class OutputEventDtoBuilder<C extends OutputEventDto, B extends OutputEventDtoBuilder<C, B>> {
        @Generated
        private UUID id;
        @Generated
        private String title;
        @Generated
        private String eventLink;
        @Generated
        private String eventType;
        @Generated
        private String content;
        @Generated
        private Integer subscribedParticipantsCount;
        @Generated
        private List<String> tags;
        @Generated
        private List<OutputInstitutionalPageDto> institutionalPages;
        @Generated
        private OutputImageDto image;
        @Generated
        private String timezone;
        @Generated
        private LocalDate startDate;
        @Generated
        private LocalDate endDate;
        @Generated
        private List<OutputEventConductorDto> eventConductors;
        @Generated
        private List<OutputScheduleDto> schedules;
        @Generated
        private List<OutputSubscribedParticipantDto> subscribedParticipants;
        @Generated
        private UUID eventPlannerId;
        @Generated
        private UUID maintainerId;
        @Generated
        private Boolean subscribed;
        @Generated
        private Instant creationTime;
        @Generated
        private Instant updateTime;

        @Generated
        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @Generated
        public B eventLink(String eventLink) {
            this.eventLink = eventLink;
            return this.self();
        }

        @Generated
        public B eventType(String eventType) {
            this.eventType = eventType;
            return this.self();
        }

        @Generated
        public B content(String content) {
            this.content = content;
            return this.self();
        }

        @Generated
        public B subscribedParticipantsCount(Integer subscribedParticipantsCount) {
            this.subscribedParticipantsCount = subscribedParticipantsCount;
            return this.self();
        }

        @Generated
        public B tags(List<String> tags) {
            this.tags = tags;
            return this.self();
        }

        @Generated
        public B institutionalPages(List<OutputInstitutionalPageDto> institutionalPages) {
            this.institutionalPages = institutionalPages;
            return this.self();
        }

        @Generated
        public B image(OutputImageDto image) {
            this.image = image;
            return this.self();
        }

        @Generated
        public B timezone(String timezone) {
            this.timezone = timezone;
            return this.self();
        }

        @Generated
        public B startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this.self();
        }

        @Generated
        public B endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this.self();
        }

        @Generated
        public B eventConductors(List<OutputEventConductorDto> eventConductors) {
            this.eventConductors = eventConductors;
            return this.self();
        }

        @Generated
        public B schedules(List<OutputScheduleDto> schedules) {
            this.schedules = schedules;
            return this.self();
        }

        @Generated
        public B subscribedParticipants(List<OutputSubscribedParticipantDto> subscribedParticipants) {
            this.subscribedParticipants = subscribedParticipants;
            return this.self();
        }

        @Generated
        public B eventPlannerId(UUID eventPlannerId) {
            this.eventPlannerId = eventPlannerId;
            return this.self();
        }

        @Generated
        public B maintainerId(UUID maintainerId) {
            this.maintainerId = maintainerId;
            return this.self();
        }

        @Generated
        public B subscribed(Boolean subscribed) {
            this.subscribed = subscribed;
            return this.self();
        }

        @Generated
        public B creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this.self();
        }

        @Generated
        public B updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OutputEventDto.OutputEventDtoBuilder(id=" + String.valueOf(this.id) + ", title=" + this.title + ", eventLink=" + this.eventLink + ", eventType=" + this.eventType + ", content=" + this.content + ", subscribedParticipantsCount=" + this.subscribedParticipantsCount + ", tags=" + String.valueOf(this.tags) + ", institutionalPages=" + String.valueOf(this.institutionalPages) + ", image=" + String.valueOf(this.image) + ", timezone=" + this.timezone + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", eventConductors=" + String.valueOf(this.eventConductors) + ", schedules=" + String.valueOf(this.schedules) + ", subscribedParticipants=" + String.valueOf(this.subscribedParticipants) + ", eventPlannerId=" + String.valueOf(this.eventPlannerId) + ", maintainerId=" + String.valueOf(this.maintainerId) + ", subscribed=" + this.subscribed + ", creationTime=" + String.valueOf(this.creationTime) + ", updateTime=" + String.valueOf(this.updateTime) + ")";
        }
    }

    @Generated
    private static final class OutputEventDtoBuilderImpl
    extends OutputEventDtoBuilder<OutputEventDto, OutputEventDtoBuilderImpl> {
        @Generated
        private OutputEventDtoBuilderImpl() {
        }

        @Override
        @Generated
        protected OutputEventDtoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OutputEventDto build() {
            return new OutputEventDto(this);
        }
    }
}

