package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalTime;
import java.util.List;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.LONG_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;

/**
 * Input DTO for program of a schedule of an event.
 */
@Schema(name = "InputProgramDto", description = "DTO for program")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputProgramDto {

    @Schema(description = "The title of the program", example = "Java Webinar")
    @NotBlank
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String title;

    @Schema(description = "The description of the program", example = "Webinar on java new and breaking changes")
    @Size(max = LONG_TEXT_LENGTH)
    private String description;

    @Schema(description = "The link for the program", example = "https://meeting.example.com/testProgram123")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String programLink;

    @Schema(description = "The program conductors")
    @Valid
    @NotEmpty
    private List<InputProgramConductorDto> programConductors;

    @Schema(description = "The place of the program", example = "Via Test Street, Floor 2, Room 1")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String place;

    @Schema(description = "The street details for map", example = "can be coordinates or actual value")
    private String street;

    @Schema(description = "The house number", example = "432b/a")
    private String houseNumber;

    @Schema(description = "The maximum number of participants allowed for the program", example = "22")
    private Integer maxParticipants;

    @Schema(description = "The start time of the program", example = "10:30:00")
    @NotNull
    private LocalTime startTime;

    @Schema(description = "The end time of the program", example = "15:30:00")
    @NotNull
    private LocalTime endTime;
}
