package com.finconsgroup.itserr.marketplace.event.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.event.bs.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.bs.messaging.ResourceProducer;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link ResourceProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerResourceProducer implements ResourceProducer {

    @Override
    public void publishCreatedResource(@NotNull OutputEventDto resource) {
        log.info("Message dispatch skipped (local profile) - CREATED for resource: {}", resource);
    }

    @Override
    public void publishUpdatedResource(@NotNull OutputEventDto resource) {
        log.info("Message dispatch skipped (local profile) - UPDATED for resource: {}", resource);
    }

    @Override
    public void publishDeletedResource(@NotNull OutputEventDto resource) {
        log.info("Message dispatch skipped (local profile) - DELETED for resource: {}", resource);
    }
}