package com.finconsgroup.itserr.marketplace.event.bs.client;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.InputSearchInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage.OutputInstitutionalPageDmDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Feign Client interface for Institutional Pages Domain Service
 */
public interface InstitutionalPageDmClient {

    /**
     * Retrieves a paginated list of all InstitutionalPages matching the search criteria.
     *
     * @param inputSearchInstitutionalPageDto the dto containing the filters to be applied
     * @param pageNumber                      the page number to retrieve (default is 0)
     * @param pageSize                        the number of InstitutionalPages per page (default is 10)
     * @param sort                            the field to sort by (default is "id")
     * @param direction                       the direction of sorting (default is ascending)
     * @return a page of {@link OutputInstitutionalPageDmDto} and HTTP status 200 (OK)
     */
    @PostMapping(value = "/institutional-page/institutional-pages/search",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    OutputPageDto<OutputInstitutionalPageDmDto> search(
            @RequestBody InputSearchInstitutionalPageDto inputSearchInstitutionalPageDto,
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );
}
