package com.finconsgroup.itserr.marketplace.event.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

/**
 * Output DTO for user profile.
 */
@Schema(name = "OutputUserProfileDto", description = "DTO representing a user profile in responses")
@Data
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class OutputUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;
}
