package com.finconsgroup.itserr.marketplace.discussion.dm.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import lombok.*;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Data Transfer Object for Thread entity.
 * This DTO is used to transfer thread data between different layers of the application.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class ThreadDTO {

    /**
     * The universally unique identifier (UUID) for the thread.
     */
    private UUID id;

    /**
     * The identifier of the user who created the thread.
     */
    private String createdBy;

    /**
     * The date and time when the thread was created.
     */
    private Instant createdAt;

    /**
     * The date and time when the thread was last modified (null if never updated).
     */
    @JsonProperty(value = "modificatedAt", access = JsonProperty.Access.READ_ONLY)
    private Instant modifiedAt;

    /**
     * The textual content of the thread.
     */
    private String content;

    /**
     * The UUID of the parent thread (null if this is a top-level thread).
     */
    private UUID parentId;

    /**
     * List of replies to this thread.
     */
    private List<ThreadDTO> replies;

    /**
     * List of reactions to this thread.
     */
    private List<ThreadReactionDTO> reactions;

    /**
     * Count of reactions grouped by reaction type.
     */
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private Map<ReactionType, Long> reactionCounts;
}
