/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.client.dm;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface DiscussionDmClient {
    @PostMapping(value={"/discussion"})
    public ResponseEntity<Void> createDiscussion(@RequestBody DiscussionDTO var1);

    @PatchMapping(value={"/discussion/{discussionId}"})
    public DiscussionDTO updateDiscussion(@PathVariable String var1, @RequestBody InputUpdateDiscussionDto var2);

    @GetMapping(value={"/discussions"})
    public Page<DiscussionDTO> getDiscussions(@RequestParam int var1, @RequestParam int var2, @RequestParam(required=false) String var3, @RequestParam(required=false) String var4, @RequestParam(required=false) String var5, @RequestParam(defaultValue="false") boolean var6);

    @GetMapping(value={"/discussion/{discussionId}/threads"})
    public Page<ThreadDTO> getThreadsByDiscussionId(@PathVariable String var1, @RequestParam(defaultValue="0") int var2, @RequestParam(defaultValue="10") int var3, @RequestParam(defaultValue="createdAt") String var4, @RequestParam(defaultValue="DESC") Sort.Direction var5);

    @DeleteMapping(value={"/discussion/{id}"})
    public ResponseEntity<Void> deleteDiscussion(@PathVariable String var1);

    @PostMapping(value={"/discussion/{discussionId}/threads"})
    public ResponseEntity<ThreadDTO> addThread(@PathVariable String var1, @RequestBody ThreadDTO var2);

    @DeleteMapping(value={"/discussion/{discussionId}/threads/{threadId}"})
    public ResponseEntity<Void> deleteThread(@PathVariable String var1, @PathVariable String var2);

    @PutMapping(value={"/discussion/{discussionId}/threads/{threadId}"})
    public ResponseEntity<ThreadDTO> updateThread(@PathVariable String var1, @PathVariable String var2, @RequestBody ThreadDTO var3);

    @PostMapping(value={"/discussion/{discussionId}/reactions/{userId}"})
    public ResponseEntity<Void> addReactionToDiscussion(@PathVariable String var1, @PathVariable String var2, @RequestParam ReactionType var3);

    @DeleteMapping(value={"/discussion/{discussionId}/reactions/{userId}"})
    public ResponseEntity<Void> removeReactionFromDiscussion(@PathVariable String var1, @PathVariable String var2);

    @PostMapping(value={"/discussion/{discussionId}/threads/{threadId}/reactions/{userId}"})
    public ResponseEntity<Void> addReactionToThread(@PathVariable String var1, @PathVariable String var2, @PathVariable String var3, @RequestParam ReactionType var4);

    @DeleteMapping(value={"/discussion/{discussionId}/threads/{threadId}/reactions/{userId}"})
    public ResponseEntity<Void> removeReactionFromThread(@PathVariable String var1, @PathVariable String var2, @PathVariable String var3);

    @GetMapping(value={"/discussion/resource/{resourceId}"})
    public DiscussionDTO getDiscussionForResource(@PathVariable String var1, @RequestParam String var2);

    @GetMapping(value={"/discussion/{discussionId}"})
    public DiscussionDTO getDiscussionByDiscussionId(@PathVariable String var1);
}

