package com.finconsgroup.itserr.marketplace.discussion.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessagingProperties {
    /**
     * Represents the configuration properties for managing events within the application.
     * The `events` property is a required configuration that encapsulates the settings
     * for event-related functionalities, such as the consumer handler logic and the
     * type of events triggered for resource creation.
     *
     * The `events` property must be populated and valid. All nested properties in
     * {@link EventsProperties} must conform to their respective validation constraints.
     */
    @NotNull
    @Valid
    private EventsProperties events;
    /**
     * Represents the configuration properties related to items within the messaging context.
     * This property encapsulates settings specific to item-related messaging features.
     *
     * The {@link ItemsProperties} class contains details such as the name of the Spring Bean
     * responsible for handling consumer-specific logic and the type of event triggered
     * when a resource is created.
     *
     * This property is mandatory and subject to validation to ensure that all nested fields
     * within {@link ItemsProperties} are properly populated.
     */
    @NotNull
    @Valid
    private ItemsProperties items;
    /**
     * Represents the configuration properties for the "news" component of the messaging system.
     * This object encapsulates specific properties required for the news messaging component,
     * such as the consumer handler bean name and the event type for resource creation.
     *
     * The `news` property is mandatory and must be validated to ensure that all required
     * fields within {@link NewsProperties} are correctly populated and valid.
     */
    @NotNull
    @Valid
    private NewsProperties news;
    /**
     * Represents the configuration properties specific to the PI-related messaging functionality.
     * This property encapsulates settings such as the consumer handler bean name
     * and the type of event triggered when a resource is created.
     *
     * The property is mandatory and validated to ensure that all nested attributes
     * within the {@link PiProperties} class are properly populated and comply
     * with the defined constraints.
     */
    @NotNull
    @Valid
    private PiProperties pi;

    @NotNull
    @Valid
    private FoldersProperties folders;

    @NotNull
    @Valid
    private DocumentsProperties documents;
}
