package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.EventsProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component("eventCreationSubscriber")
@RequiredArgsConstructor
@Slf4j
public class EventCreationSubscriber extends AbstractResourceSubscriber {

    private final CreationDiscussionUtility creationDiscussionUtility;
    private final EventsProperties eventsProperties;

    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, eventsProperties.getResourceCreatedEventType())) {
            creationDiscussionUtility.create(id, eventData, ResourceType.EVENT.getValue());
        }
    }
}
